#ifndef SNAKE_TESTS_H
#define SNAKE_TESTS_H

bool testSnakeMovement()
{
    
    // create snake object and initialise
    Snake snake;
    snake.init(40, 24);
    // get and print the snake position
    LCDVector initial_position = snake.getPosition();
    printf("TEST // initial position: (%d, %d)\n", initial_position.x, initial_position.y);
    
    // manual inputs
    snake.update(0, S, A);      // down
    snake.update(0, S, A);      // down
    snake.update(0, W, X);      // left
    snake.update(0, N, Y);      // up
    snake.update(0, E, B);      // right
    snake.update(0, E, B);      // right
    
    // get and print the updated snake position
    LCDVector updated_position = snake.getPosition();
    printf("TEST // updated position: (%d, %d)\n", updated_position.x, updated_position.y);

    bool success_flag = true;

    // if the initial snake position vector does not equal (40, 24), fail the test
    if (initial_position.x != 40 || initial_position.y != 24) {

        printf("TEST // inital position incorrect\n");
        success_flag = false;
    }
    
    // if the updated snake position vector does not equal (44, 28), fail the test
    if (updated_position.x != 44 || updated_position.y != 28) {

        printf("TEST // updated position incorrect\n");
        success_flag = false;
    }

    return success_flag;
}

bool testSnakeWrapX()
{
    
    // create snake object and initialise
    Snake snake;
    snake.init(0, 24);
    // get and print the snake position
    LCDVector initial_position = snake.getPosition();
    printf("TEST // initial position: (%d, %d)\n", initial_position.x, initial_position.y);
    
    // update the snake left one block
    snake.update(0, W, X);
    // get and print the updated snake position
    LCDVector updated_position = snake.getPosition();
    printf("TEST // updated position: (%d, %d)\n", updated_position.x, updated_position.y);

    bool success_flag = true;
    
    // if the updated snake position x-coordinate does not equal 80, fail the test
    if (updated_position.x != 80) {

        success_flag = false;
    }

    return success_flag;
}

bool testSnakeWrapY()
{
    
    // create snake object and initialise
    Snake snake;
    snake.init(40, 0);
    // get and print the snake position
    LCDVector initial_position = snake.getPosition();
    printf("TEST // initial position: (%d, %d)\n", initial_position.x, initial_position.y);
    
    // update the snake up one time
    snake.update(0, N, Y);
    // get and print the snake position
    LCDVector updated_position = snake.getPosition();
    printf("TEST // updated position: (%d, %d)\n", updated_position.x, updated_position.y);

    bool success_flag = true;
    
    // if the updated snake position y-coordinate does not equal 44, fail the test
    if (updated_position.y != 44) {

        success_flag = false;
    }

    return success_flag;
}

#endif