#ifndef SNAKE_H
#define SNAKE_H

#include "Border.h"
#include "Gamepad.h"
#include "mbed.h"
#include "N5110.h"

/** Snake Class
* @brief Controls the snake movement, graphics and state
* @author EL16RF
* @date Mar, 2018
*/

class Snake
{

public:
    /** Constructor */
    Snake();
    /** Deconstructor */
    ~Snake();
    
    // functions
    /** Initialises the snake */
    void init(int x, int y);
    
    /** Update the snake
    * @param control_type (int) - the snake control type (0-1)
    * @param dir (Direction) - the directional input from the stick
    * @param abxy (ABXYEvent) - the directional input from buttons A, B, X and Y */
    void update(int control_type, Direction dir, ABXYEvent abxy);
    
    /** Draws the entire snake into the LCD buffer
    * @param &lcd (N5110) - the buffer write target */
    void draw(N5110 &lcd);
    
    /** Draws the snake head into the LCD buffer
    * @param &lcd (N5110) - the buffer write target */
    void drawHead(N5110 &lcd);
    
    /** Draws the snake tail into the LCD buffer
    * @param &lcd (N5110) - the buffer write target */
    void drawTail(N5110 &lcd);
    
    /** Snake head vector accessor
    * @return (LCDVector) the current snake head position */
    LCDVector getPosition();
    
    /** Snake length accessor
    * @return (int) the current snake length */
    int getLength();
    
    /** Snake length increment mutator */
    void incrementLength();    
    
    // variables
    int state[WIDTH][HEIGHT];
    LCDVector tail[190]; 

private:
    // functions
    void userInput(int control_type, Direction dir, ABXYEvent abxy);
    void abxyInput(ABXYEvent abxy);
    void stickInput(Direction dir);
    void wrap();

    // variables
    int _x;
    int _y;
    int _x_velocity;
    int _y_velocity;
    int _length;
};

#endif