#ifndef GAMEENGINE_TESTS_H
#define GAMEENGINE_TESTS_H

bool testVectorCollision()
{   

    // create food object and initialise it
    Food food;
    food.init();
    // get and print the food position
    LCDVector initial_food_position = food.getPosition();
    printf("TEST // food position: (%d, %d)\n", initial_food_position.x, initial_food_position.y);
    
    // create snake object and initialise it at the same vector as the food
    Snake snake;
    snake.init(initial_food_position.x, initial_food_position.y);
    // get and print the snake position
    LCDVector snake_position = snake.getPosition();
    printf("TEST // snake position: (%d, %d)\n", snake_position.x, snake_position.y);

    bool success_flag = true;
    
    // if food and snake vectors match, continue the test
    if (initial_food_position.x == snake_position.x || initial_food_position.y == snake_position.y) {
        
        // wait to allow srand(time(NULL)) to change
        wait(1.0f);
        // update the food position
        food.update();
    }
    
    // else fail the test
    else {

        printf("TEST // food and snake positions do not match\n");
        success_flag = false;
    }
    
    // get updated food position vector
    LCDVector updated_food_position = food.getPosition();
    
    // if the initial and updated food positions are the same, fail the test
    if (initial_food_position.x == updated_food_position.x && initial_food_position.y == updated_food_position.y) {

        printf("TEST // food position not updated\n");
        success_flag = false;
    }

    return success_flag;
}

#endif