#ifndef FOOD_H
#define FOOD_H

#include "Bitmap.h"
#include "Border.h"
#include "Gamepad.h"
#include "mbed.h"
#include "N5110.h"

/** Food Class
* @brief Controls the food position, graphics and state
* @author EL16RF
* @date Mar, 2018
*/

class Food
{

public:
    /** Constructor */
    Food();
    /** Deconstructor */
    ~Food();
    
    // functions
    /** Initialises the food */
    void init();
    
    /** Updates the food */
    void update();
    
    /** Draws the food into the LCD buffer
    * @param &lcd (N5110) - the buffer write target */
    void draw(N5110 &lcd);
    
    /** Food vector accessor
    * @return (LCDVector) the current food position */
    LCDVector getPosition();
    
    // variables
    int state[WIDTH][HEIGHT];

private:
    // functions
    void randomiseBufferPosition();
    
    // variables
    int _x;
    int _y;
};

#endif