#include "Border.h"

// constructor
Border::Border()
{

}

// deconstructor
Border::~Border()
{

}

void Border::draw(int border_type, N5110 &lcd)
{
    
    // evaluate the border type
    switch (border_type) {
        
        // case border type = 0
        case 0:
            drawFullBorder(lcd);
            break;
        
        // case border type = 1
        case 1:
            drawSplitBorder(lcd);
            break;
    }
}

void Border::drawFullBorder(N5110 &lcd)
{
    
    // draw successively smaller rectangles GRID_SIZE times
    for (int i = 0; i < GRID_SIZE; i++) {
        
        lcd.drawRect(i, i, WIDTH - (i * 2), HEIGHT - (i * 2), FILL_TRANSPARENT);
    }
}

void Border::drawSplitBorder(N5110 &lcd)
{
    
    // draw full border
    drawFullBorder(lcd);
    
    // set certain pixels in normal border to false, to create the split border
    // left - x
    for (int i = 0; i < GRID_SIZE; i++) {
        
        // left - y
        for (int j = GRID_SIZE * 4; j < HEIGHT - (GRID_SIZE * 4); j++) {
            
            // set pixels off
            lcd.setPixel(i, j, false);
        }
    }
    
    // right - x
    for (int i = 80; i < WIDTH; i++) {
        
        // right - y
        for (int j = GRID_SIZE * 4; j < HEIGHT - (GRID_SIZE * 4); j++) {
            
            // set pixels off
            lcd.setPixel(i, j, false);
        }
    }
    
    // top - y
    for (int i = 0; i < 4; i++) {
        
        // top - x
        for (int j = GRID_SIZE * 8; j < WIDTH - (GRID_SIZE * 8); j++) {
            
            // set pixels off
            lcd.setPixel(j, i, false);
        }
    }
    
    // bottom - y
    for (int i = 44; i < HEIGHT; i++) {
        
        // bottom - x
        for (int j = GRID_SIZE * 8; j < WIDTH - (GRID_SIZE * 8); j++) {
            
            // set pixels off
            lcd.setPixel(j, i, false);
        }
    }
}