#include "Snake.h"

// constructor
Snake::Snake()
{

}

// deconstructor
Snake::~Snake()
{

}

void Snake::init(int x, int y)
{
    // set x and y position from function arguments
    _x = x;
    _y = y;
    // printf("snake position initialised (render vector x: %dpx y: %dpx)\n", _x, _y);
    // set inital length
    _length = 1;
    // set starting velocities
    _x_velocity = _y_velocity = 0;
    // set index 0 of the tail position array to the current position of the snake head
    tail[0] = getPosition();
}

void Snake::update(int control_type, Direction dir, ABXYEvent abxy)
{
    // update velocities based on input type
    userInput(control_type, dir, abxy);
    // adjust x and y positions accordingly
    _x += _x_velocity * GRID_SIZE;
    _y += _y_velocity * GRID_SIZE;
    // flip the snake head position if its vector exceeds the screen limits
    wrap();

    // from the end of the snake tail to its head
    for (int i = _length; i >= 0; i--) {
        // shift tail array elements up
        tail[i + 1] = tail[i];
    }

    // set index 0 of the tail position array to the current position of the snake head
    tail[0] = getPosition();
    // printf("snake position updated (render vector x: %dpx y: %dpx)\n", tail[0].x, tail[0].y);
}

void Snake::draw(N5110 &lcd)
{
    // draw head and tail
    drawHead(lcd);
    drawTail(lcd);
}

void Snake::drawHead(N5110 &lcd)
{
    // draw head from the vector stored at index 0 of the tail array
    lcd.drawRect(tail[0].x, tail[0].y, GRID_SIZE, GRID_SIZE, FILL_BLACK);
}

void Snake::drawTail(N5110 &lcd)
{
    // for the length of the snake
    for (int i = 1; i < _length; i++) {
        // draw tail from the vectors stored from index 1 to length
        lcd.drawRect(tail[i].x, tail[i].y, GRID_SIZE, GRID_SIZE, FILL_BLACK);
    }
}

LCDVector Snake::getPosition()
{
    // return a vector of the current x and y position
    LCDVector pos = {_x, _y};
    return pos;
}

int Snake::getLength()
{

    // return the current snake length
    return _length;
}

void Snake::incrementLength()
{

    // add 1 to length
    _length++;
}

// directional control
void Snake::userInput(int control_type, Direction dir, ABXYEvent abxy)
{
    // if control type = 1, use ABXY control
    if (control_type) {
        abxyInput(abxy);
    }

    // else use stick control
    else {
        stickInput(dir);
    }
}

void Snake::stickInput(Direction dir)
{
    // evaluate states of dir
    switch (dir) {
        case N:
            _x_velocity = 0;
            _y_velocity = -1;
            // printf("input: up\n");
            break;

        case E:
            _x_velocity = 1;
            _y_velocity = 0;
            // printf("input: right\n");
            break;

        case S:
            _x_velocity = 0;
            _y_velocity = 1;
            // printf("input: down\n");
            break;

        case W:
            _x_velocity = -1;
            _y_velocity = 0;
            // printf("input: left\n");
            break;
    }
}

void Snake::abxyInput(ABXYEvent abxy)
{
    // evaluate states of abxy
    switch (abxy) {
        case A:
            _x_velocity = 0;
            _y_velocity = 1;
            // printf("input: down\n");
            break;

        case B:
            _x_velocity = 1;
            _y_velocity = 0;
            // printf("input: right\n");
            break;

        case X:
            _x_velocity = -1;
            _y_velocity = 0;
            // printf("input: left\n");
            break;

        case Y:
            _x_velocity = 0;
            _y_velocity = -1;
            // printf("input: up\n");
            break;
    }
}

void Snake::wrap()
{
    // if x surpasses the left limit of the lcd
    if (_x < 0) {
        // reverse x position
        _x = WIDTH - GRID_SIZE;
    }

    // if x surpasses the right limit of the lcd
    else if (_x > WIDTH) {
        // reverse x position
        _x = 0;
    }

    // if y surpasses the upper limit of the lcd
    if (_y < 0) {
        // reverse y position
        _y = HEIGHT - GRID_SIZE;
    }

    // if y surpasses the lower limit of the lcd
    else if (_y > HEIGHT) {
        // reverse y position
        _y = 0;
    }
}