#include "Food.h"

// constructor
Food::Food()
{

}

// deconstructor
Food::~Food()
{

}

void Food::init()
{
    
    // randomise x and y position
    randomiseBufferPosition();
    // printf("food position initialised (render vector x: %dpx y: %dpx)\n", _x, _y);
}

void Food::update()
{ 

    // randomise x and y position
    randomiseBufferPosition();
    // printf("food position updated (render vector x: %dpx y: %dpx)\n", _x, _y);
}

void Food::draw(N5110 &lcd)
{
    
    // define food sprite data
    static int sprite_data[] = {
        
        0, 1, 1, 0,
        1, 1, 1, 1,
        1, 1, 1, 1,
        0, 1, 1, 0
    };
    
    // create a sprite from food sprite data
    Bitmap sprite(sprite_data, 4, 4);
    // render food sprite
    sprite.render(lcd, _x, _y);
}

LCDVector Food::getPosition()
{
    
    // return a vecotr of the current x and y position
    LCDVector pos = {_x, _y};
    return pos;
}

void Food::randomiseBufferPosition()
{
    
    // seed rand() with respect to time
    // https://www.youtube.com/watch?v=qs8vVgy5AMc
    srand(time(NULL));
    // psuedorandom x and y values generated between (4, 4) and (76, 40)
    _x = (rand() % ((WIDTH - (2 * GRID_SIZE)) / GRID_SIZE) + 1) * GRID_SIZE;
    _y = (rand() % ((HEIGHT - (2 * GRID_SIZE)) / GRID_SIZE) + 1) * GRID_SIZE;
}