#ifndef TESTS_H
#define TESTS_H

#include "Snake_tests.h"
#include "GameEngine_tests.h"

int run_all_tests()
{

    int tests_failed = 0;
    bool test_passed = false;

    // run snake movement test
    printf("TEST // testing snake movement\n");
    test_passed = testSnakeMovement();

    if (test_passed) {

        printf("TEST // snake movement test passed\n");
    }

    else {

        printf("TEST // snake movement test failed\n");
        ++tests_failed;
    }
    
    // run snake wrap x test
    printf("TEST // testing x-axis snake wrap\n");
    test_passed = testSnakeWrapX();

    if (test_passed) {

        printf("TEST // x-axis snake wrap test passed\n");
    }

    else {

        printf("TEST // x-axis snake wrap test failed\n");
        ++tests_failed;
    }
    
    // run snake wrap y test
    printf("TEST // testing y-axis snake wrap\n");
    test_passed = testSnakeWrapY();

    if (test_passed) {

        printf("TEST // y-axis snake wrap test passed\n");
    }

    else {

        printf("TEST // y-axis snake wrap test failed\n");
        ++tests_failed;
    }

    // run vector collision test
    printf("TEST // testing vector collision\n");
    test_passed = testVectorCollision();

    if (test_passed) {

        printf("TEST // vector collision test passed\n");
    }

    else {

        printf("TEST // vector collision test failed\n");
        ++tests_failed;
    }

    // test results
    if (tests_failed > 0) {

        printf("TEST // %d test(s) failed\n", tests_failed);
    }

    else {

        printf("TEST // all tests passed\n");
    }

    return tests_failed;
}

#endif