/*
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
Name: Reuben Frankel
Username: EL16RF
Student ID Number: 201042778
Date: 06/03/2018
*/

#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "GameEngine.h"
#include "TitleScreen.h"

#ifdef WITH_TESTING
#include "tests.h"
#endif

// object declarations
N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);
Gamepad gamepad;
GameEngine game;
TitleScreen title_screen;

// function prototypes
void init();
void draw(int border_type);

int main()
{
    
    // testing macro code
    #ifdef WITH_TESTING
    int failed_tests = run_all_tests();

    if (failed_tests > 0) {

        return failed_tests;
    }
    #endif
    
    // set fps
    int fps = 5;
    init();

    // title screen loop
    while (title_screen.getExitStatus() == false) {

        title_screen.readInput(gamepad);
        title_screen.update(lcd, gamepad);
        title_screen.draw(lcd, gamepad);
        wait(1.0f / fps);
    }
    
    // get the control and border type defined in the setup menu (default 0)
    int control_type = title_screen.getControlType();
    int border_type = title_screen.getBorderType();
    
    // main game loop
    while (1) {

        game.writeObjectStates(lcd, border_type);
        game.readInput(gamepad);
        // printf("input read\n");
        game.update(gamepad, lcd, control_type);
        // printf("gamepad updated\n");
        draw(border_type);
        // printf("lcd updated\n");
        wait(1.0f / fps);
    }
}

void init()
{

    lcd.init();
    gamepad.init();
    title_screen.init();
    game.init();
}

void draw(int border_type)
{

    lcd.clear();
    game.draw(border_type, lcd);
    lcd.refresh();
}