#ifndef TITLESCREEN_H
#define TITLESCREEN_H

#include "Bitmap.h"
#include "Gamepad.h"
#include "mbed.h"
#include "N5110.h"

/** TitleScreen Class
* @brief Controls the title screen GUI, and control/border-state selection
* @author EL16RF
* @date Apr, 2018
*/

class TitleScreen
{

public:
    /** Constructor */
    TitleScreen();
    /** Deconstructor */
    ~TitleScreen();

    // functions
    /** Initialises the title screen */
    void init();
    
    /** Reads inputs from the gamepad
    * @param &gamepad (Gamepad) - the input source */
    void readInput(Gamepad &gamepad);
    
    /** Updates the title screen
    * @param &lcd (N5110) - the buffer write target
    * @param &gamepad (Gamepad) - the input source */
    void update(N5110 &lcd, Gamepad &gamepad);
    
    /** Draws the title screen menus into the LCD buffer
    * @param &lcd (N5110) - the buffer write target
    * @param &gamepad (Gamepad) - the input source */
    void draw(N5110 &lcd, Gamepad &gamepad);
    
    /* Control type accessor
    * @return (int) the control type defined in the setup menu (0-1) */
    int getControlType();

    /* Border type accessor
    * @return (int) the border type defined in the setup menu (0-1) */
    int getBorderType();

    /* Exit status accessor
    * @return (bool) the exit argument */
    bool getExitStatus();   

private:
    // functions
    void updateMainMenu(N5110 &lcd, Gamepad &gamepad);
    void updateSetupMenu(N5110 &lcd, Gamepad &gamepad);
    void drawMainMenu(N5110 &lcd);
    void drawSetupMenu(N5110 &lcd, Gamepad &gamepad);
    void drawSelector(N5110 &lcd, int x, int y, bool state);
    void clearSelector(N5110 &lcd, int x, int y);
    
    // variables
    bool _start;
    bool _back;
    bool _l;
    bool _r;
    int _scene;
    int _control_type;
    int _border_type;
    bool _exit_status;   
};

#endif