#ifndef BORDER_H
#define BORDER_H

#include "Gamepad.h"
#include "mbed.h"
#include "N5110.h"

/** Border Class
* @brief Controls the border style, graphics and state
* @author EL16RF
* @date Apr, 2018
*/

class Border
{

public:
    /** Constructor */
    Border();
    /** Deconstructor */
    ~Border();
    
    // functions
    /** Draws the specified border type into the LCD buffer
    * @param border_type (int) - the border type (0-1)
    * @param &lcd (N5110) - the buffer write target */
    void draw(int border_type, N5110 &lcd);
    
    // variables
    int state[WIDTH][HEIGHT];    

private:
    // functions
    void drawFullBorder(N5110 &lcd);
    void drawSplitBorder(N5110 &lcd);
};

#endif