#include "mbed.h"

#include "main.h"



/*
El sitema tiene tres estados:
1. Standby: estado que indica que esta en espera de un telecomando (Ejecutar 0 guardar)
2. Drawing: estado en donde el piccolo eejecuta las ordenes giardadas en el array 
            de memora hasta encontrar el comando CM_STOP 
3. Saving:  estado donde el sistema recibe lso datos y lso almacena en memoria acorde 
            a los comandos de 0xfd, oxfc, 0xfb,0cfa, se sake de este modo cuado se recibe
            el comando CM_STOP
            
todo telecomando debe finalizar con el dato CM_END
*/


Serial command(USBTX, USBRX);



int main() {
    init_servo();
    init_serial();
    draw();
    nodraw();
    home();
    debug_m("inicio \n");
    uint32_t read_cc;
    while(1)
    {
        read_cc=read_command();
        switch (read_cc) {
            case  CM_DRAWING: drawing(); break;
            case  CM_SAVING: saving(); break;
            default: debug_m("error de comando. \nSe espera  0xFEF0 o 0xFFF0 \n");break ;      
        }
    }
}



uint32_t read_command()
{
   // retorna los byte recibidos concatenados en un entero, se reciben maximo 4 bytes,
   // recibe hasta que encuetra  un fin de comando "CM_END".
   // Ejemplo: para el comando drawing se 
   // espera un byte,  por lo que al recibir 0xFF y 0xF0 la funcióm  retorna el 0xff
   // siempre y cuando se reciba el fin de dato  F0 de lo contrario retorna un cero
   // para el caso del comando vertex2d se espera  recibir 3 bytes, 1 del comando 
   // y dos bytes para x y y, se retorna la concatenación de los tres bytes  siempre y
   // cuando el cuarto byte sea CM_END de lo contrario retorna un cero 
   
    uint32_t val=0;
    uint8_t  cnt=0;
    
    char endc=command.getc();
    
    while(endc != CM_END && cnt <4) {
    if(endc!=CM_END)   
        val=((val<<8) +endc);
     endc=command.getc();
     cnt++;
    }   
    if(endc==CM_END)   
        return val;
    return 0;   //al retornar 0 indica que  no se recibe el comando  
}
void init_serial()
{
    command.baud(9600);    
}


void drawing()
{
    // la funcion se ejecuta siemrpe y cuando exista datos validos para leer de 
    // memoria 
    debug_m("se esta ejecutando el dibujo... \n");       
     
    uint8_t error=0;
    MEM_TYPE dato;

    tail_reset();

    while(error==0){
        error = mem_get(&dato);
        if (error==0) {
            switch (dato) {
            case  CM_DRAW: 
                    debug_m("-> Baja Z\n");
                    draw();
                    break ;     
            case  CM_NODRAW: 
                    debug_m("-> Sube Z\n");
                    nodraw();
                    break ;     
            default: 
                int y      = (uint8_t)(dato);
                int x      = (uint8_t)(dato>>8);
                char ncomm  = (uint8_t)(dato>>16);
                
                if (ncomm == CM_VERTEX2D) {
                    debug_m("-> Mover piccolo x a %d y y a %d \n",x,x, y);
                    vertex2d(x,y);
                                           }
                else
                    debug_m("-> ERROR DE COMMANDO: %d %d %d \n " ,ncomm,x,y,y);
                break;   
                           }
                       }        
                    }  
    
    debug_m("fin del comando dibujar..\n");    
    
}


void saving(){
    debug_m("se inicia el comado guardar..\n");    
    
    MEM_TYPE dato=0;
    mem_free();
    while(dato !=CM_STOP){
        dato = read_command();
        if (dato !=CM_STOP)
               mem_put(dato);
    }  
    debug_m("fin del comado guardar..\n");    
    
}

void debug_m(char *s , ... ){
    #if DEBUG
    command.printf(s);
    #endif  
}