
#include "mbed.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "platform/mbed_thread.h"
#include "LiquidCrystal_I2C.h"

typedef struct Clock_Typedef

{
    int hour;
    int Minutes;
    int Second;
    int Param_Select;
    int Alarm_State;
    char Alrm[3];
} Clock_Typedef;


typedef enum Clock_Set {
    ClockTime=0,
    ClockAlarm
} Clock_Set;


//structures to hold the Clock and alarm parameters
Clock_Typedef clock1= {0};
Clock_Typedef  Alarm= {0};
int set_choice=0;
char Hold[17];
LiquidCrystal_I2C lcd(0x4E, 16, 2);
Ticker TIMER;
DigitalOut Buzzer(PA_5);                        //ALARM BUZZER connected to Pin PA_5
InterruptIn CLOCK_STATE(PC_13);                  //User-button PC13 is configured as interrupt to switch from time to alarm
InterruptIn T0_Set_Alarm(PA_6);                  //User-button PA6 is configured to set alarm by incrementinting alarm hourss,min or seconds according to setchoice in alarm stucture
InterruptIn Increment_Alarm_par(PA_7);           //User-button PA7 is used to select which alarm parameter to setChoice of inrementinted variabale in Alarm, either Minutes or Hours
InterruptIn ALARM_ON_OFF(PB_12);                 //User-button PC7 is used to set alarm ON or OFF
InterruptIn To_SnoozeAlrm(PA_8);                 //User-button PA_8 is used snooze alarm for 5 minutes


void UPdat_Alarm_Time(Clock_Typedef *Choice)
{
    if(set_choice==0) {
        Choice->Minutes++;
        if(Choice->Minutes>59) {
            Choice->Minutes=0;
        }
    }
    if(set_choice==1) {
        Choice->hour++;
        if(Choice->hour>23) {
            Choice->hour=0;
        }
    }
}
void Time_increment(Clock_Typedef *Clock_Param)
{
    Clock_Param->Second++;
    if(Clock_Param->Second>59)
    {
        Clock_Param->Second=0;
        Clock_Param->Minutes++;
    }
    if(Clock_Param->Minutes>59) {
        Clock_Param->Minutes=0;
        Clock_Param->hour++;
    }
    if(Clock_Param->hour>23) {
        Clock_Param->hour++;
    }
}

void Set_Alarm_Time()
{
    if(clock1.Param_Select==0) {
        UPdat_Alarm_Time(&clock1);
    } else {
        UPdat_Alarm_Time(&Alarm);
    }
}
void Set_Alarm_ON_OFF()
{
    Buzzer=0;
    if(++clock1.Alarm_State>1) {
        clock1.Alarm_State=0;
    }
    if( clock1.Alarm_State==0)
    {
        sprintf(clock1.Alrm,"%s","OFF");
    }
    if(clock1.Alarm_State==1)
    {
        sprintf(clock1.Alrm,"%s","ON");
    }
}


void Time_move()
{
    Time_increment(&clock1);
}
void increment(void)
{
    if(++set_choice>1) {
        set_choice=0;
    }
}
void Set_CLOCK_STATE(void)
{
    if(clock1.Param_Select==0) {
        clock1.Param_Select=1;
    } else {
        clock1.Param_Select=0;
    }
}
void Snooze()
{
        if(clock1.Alarm_State==1)
        {
            Buzzer=0;
            int compu=Alarm.Minutes+5;
            if(compu>59)
            {
                Alarm.Minutes=compu-60;
                Alarm.hour++;
                if(Alarm.hour>23)
                {
                    Alarm.hour=0;
                }
            }
            else
            {
                Alarm.Minutes=compu;
            }
            Alarm.Alarm_State=1;
        }
}

int IsAlarmOn(void)
{
    if(clock1.Alarm_State==1) 
    {
        if(Alarm.Minutes==clock1.Minutes && Alarm.hour==clock1.hour) {
            return 1;

        }
    }
    return 0;
}

int main()
{
    TIMER.attach(&Time_move, 1s);
    CLOCK_STATE.mode(PullUp);
    T0_Set_Alarm.mode(PullUp);
    Increment_Alarm_par.mode(PullUp);
    ALARM_ON_OFF.mode(PullUp);
    To_SnoozeAlrm.mode(PullUp);
    CLOCK_STATE.fall(&Set_CLOCK_STATE);
    T0_Set_Alarm.fall(&Set_Alarm_Time);
    Increment_Alarm_par.fall(&increment);
    ALARM_ON_OFF.fall(&Set_Alarm_ON_OFF);
    To_SnoozeAlrm.fall(&Snooze);
    sprintf(clock1.Alrm,"%s","OFF");
    while (1) {
        switch(clock1.Param_Select) {
            case 0:
                lcd.clear();
                lcd.setCursor(0,0);
                sprintf(Hold,"TIME : %d%d:%d%d",clock1.hour/10,clock1.hour%10,clock1.Minutes/10,clock1.Minutes%10);
                lcd.print(Hold);
                if(IsAlarmOn()==1)
                {
                    Buzzer=1;
                }
                break;
            case 1:
                lcd.clear();
                lcd.setCursor(0,0);
                sprintf(Hold,"ALARM: %d%d:%d%d",Alarm.hour/10,Alarm.hour%10,Alarm.Minutes/10, Alarm.Minutes%10);
                lcd.print(Hold);
                lcd.setCursor(0,1);
                sprintf(Hold,"ALARM:%s",clock1.Alrm);
                lcd.print(Hold);
                IsAlarmOn();
                break;
        }
        wait_us(100000);

    }
}