include "myGPS.h"
void myGPS::setTarget(float a,  float b)
{
T_Lat = a;
T_Lon = b; }
void myGPS::update()
{
    read_nmea();
    chop_message(nmea1);
    present_array();
    chop_message(nmea2);
    present_array();
}
myGPS::myGPS(PinName tx,PinName rx) :ser(tx,rx) {
    T_Lon = T_Lat= 0;
 }
//--------------------read nmea from GPS unit-------------------- 
void myGPS::read_nmea(void) {
//    char nmeabuff[100];
//    for(int i = 0; i< 5;i++)
    do{
     myGPS::ser.scanf("%s",nmea1);
}while(!((nmea1[2]=='P') and (nmea1[3]=='G') and (nmea1[4]=='G') and (nmea1[5]=='A')));
   // pc->printf("%s\r\n",nmea1);
do{
myGPS::ser.scanf("%s",nmea2);
}while(!((nmea2[2]=='P') and (nmea2[3]=='R') and (nmea2[4]=='M') and
(nmea2[5]=='C')));
   // pc->printf("%s\r\n",nmea2);
}
//---------------- chop the nmea message separated by comma's----------- 
int myGPS::chop_message(char nmea[]) {
     for (int k=0; k<MAX_STR; k++) {
char array is set to 0x00
         for (int l=0; l<STR_LEN; l++) {
             gp[k][l]= 0x00;
}; 
}
     int strcnt=0;
     int strpos=0;
    for (int k=0; k < MESS_LEN; k++) {

if (nmea[k] == '*') {
    gp[strcnt][strpos]= 0x00;
    return 0;
if (nmea[k] == 0x2c) {
    if (strpos == 0) {
        gp[strcnt][0]= 'E';


gp[strcnt][1]='m';
gp[strcnt][2]='p';

gp[strcnt][3]= 't';
gp[strcnt][4]= 'y';
gp[strcnt][5]= 0x00;
           } else {
                gp[strcnt][strpos]= 0x00;
            }
            strcnt += 1;
            strpos =0;
        } else {
            gp[strcnt][strpos]= nmea[k];
            strpos += 1;
} }
return 0; 
}

// --------------- Dump only $GPGGA on the
void myGPS::present_array() {
// --------------- Dump only $GPRMC on the screen------------------
if ((gp[0][2]=='P') and (gp[0][3]=='R') and (gp[0][4]=='M') and (gp[0][5]=='C'))
 {
  myGPS::Speed=(gp[7][0]-0x30)*100+(gp[7][1]-0x30)*10+(gp[7][2]- 0x30)+(gp[7][4]-0x30)/10.0; //10.0 giveg the floating point decimal
   myGPS::Course=(gp[8][0]-0x30)*100+(gp[8][1]-0x30)*10+(gp[8][2]- 0x30)+(gp[8][4]-0x30)/10.0;
      }
if ((gp[0][2]=='P') and (gp[0][3]=='G') and (gp[0][4]=='G') and (gp[0][5]=='A')) 
{
int Lat_deg=(gp[2][0]-0x30)*10+(gp[2][1]-0x30);
 int Lat_min=(gp[2][2]-0x30)*10+(gp[2][3]-0x30); 
 float Lat_sec=((((gp[2][5]-0x30)*1000+(gp[2][6]- 0x30)*100+(gp[2][7]-0x30)*10+(gp[2][8]-0x30)))/1000.000);
  myGPS::Sec_Lat=Lat_deg*60*60+Lat_min*60+Lat_sec;
int Lon_deg=(gp[4][0]-0x30)*100+(gp[4][1]-0x30)*10+gp[4][2]- 0x30;
int Lon_min=(gp[4][3]-0x30)*10+(gp[4][4]-0x30);
float Lon_sec=((((gp[4][6]-0x30)*1000+(gp[4][7]- 0x30)*100+(gp[4][8]-0x30)*10+(gp[4][9]-0x30)))/1000.000);
myGPS::Sec_Lon=Lon_deg*60*60+Lon_min*60+Lon_sec; 
#define PI 3.141592
myGPS::Theta=(PI-atan2((Sec_Lon-T_Lon),(Sec_Lat-T_Lat)))*180/PI; 
myGPS::Satnum = (gp[7][0]-0x30)*10+(gp[7][1]-0x30);
myGPS:: Altitude = (gp[9][0]-0x30)*10000+(gp[9][1]- 0x30)*1000+(gp[9][2]-0x30)*100+(gp[9][3]-0x30)*10+(gp[9][4]-0x30)+(gp[9][6]- 0x30)*0.1;
}
 }