#include "Accelerometer.h"
Accelerometer::Accelerometer(PinName xoutPin, PinName youtPin,PinName zoutPin,PinName sleepPin, PinName zeroGDetectPin, PinName gSelectPin) : xout(xoutPin), yout(youtPin), zout(zoutPin),
     zeroGDetect(zeroGDetectPin),
     sleep(sleepPin), gSelect(gSelectPin), zeroG(zeroGDetectPin)
{
     sleep = 1; // normal mode
     gSelect = 0; // 1.5G mode
     scale = 0.8;
}
float Accelerometer::getAccel() {
     float x = getAccelX();
     float y = getAccelY();
     float z = getAccelZ();
     return sqrt(x * x + y * y + z * z);
}
float Accelerometer::getAccelX() {
     return ((xout * 3.3) - 1.65) / scale;
}
float Accelerometer::getAccelY() {
     return ((yout * 3.3) - 1.65) / scale;
}
float Accelerometer::getAccelZ() {
     return ((zout * 3.3) - 1.65) / scale;
}
float Accelerometer::getTiltX() {
 float x = getAccelX();
     float y = getAccelY();
     float z = getAccelZ();
     float a = sqrt(x * x + y * y + z * z);
     return asin(x / a);
}
float Accelerometer::getTiltY() {
     float x = getAccelX();
     float y = getAccelY();
     float z = getAccelZ();
     float a = sqrt(x * x + y * y + z * z);
     return asin(y / a);
}
float Accelerometer::getTiltZ() {
     float x = getAccelX();
     float y = getAccelY();
     float z = getAccelZ();
     float a = sqrt(x * x + y * y + z * z);
     return asin(z / a);
}
void Accelerometer::setScale(Scale scale) {
     switch (scale) {
} }
case SCALE_1_5G:
     this->scale = 0.8;
     gSelect = 0;
     break;
case SCALE_6G:
     this->scale = 0.206;
     gSelect = 1;
     break;
void Accelerometer::setSleep(bool on) {
     sleep = !on;
}
bool Accelerometer::detectedZeroG() {
     return zeroGDetect;
}
void Accelerometer::setZeroGDetectListener(void (*func)(void)) {
     zeroG.rise(func);
}
template<typename T> void
Accelerometer::setZeroGDetectListener(T* t, void
(T::*func)(void)) {
     zeroG.rise(t, func);
}