#ifndef ACCELEROMETER_H
#define ACCELEROMETER_H
#include "mbed.h"
class Accelerometer {
public:
     Accelerometer(PinName xoutPin, PinName youtPin,PinName zoutPin,PinName sleepPin, PinName zeroGDetectPin, PinName gSelectPin);
     enum Scale {SCALE_1_5G, SCALE_6G};
     float getAccel();
     float getAccelX();
     float getAccelY();
     float getAccelZ();
     float getTiltX();
     float getTiltY();
     float getTiltZ();
     void setScale(Scale scale);
     void setSleep(bool on);
     bool detectedZeroG();
     void setZeroGDetectListener(void (*func)(void));
     template<typename T> void setZeroGDetectListener(T* t, void(T::*func)(void));
private:
     AnalogIn xout, yout, zout;
     DigitalIn zeroGDetect;
     DigitalOut sleep;
     DigitalOut gSelect;
     InterruptIn zeroG;
     float scale;
}; 
#endif