#include "Huzzah.h"


extern Serial pc;
extern volatile int tx_in;
extern volatile int tx_out;
extern volatile int rx_in;
extern volatile int rx_out;
extern char tx_buffer[4096];
extern char rx_buffer[4096];


Huzzah::Huzzah(PinName tx_pin, PinName rx_pin, string ssid, string pwd)
    :esp(tx_pin, rx_pin), ssid(ssid), pwd(pwd)
{
    tx_in=0;
    tx_out=0;
    rx_in=0;
    rx_out=0;
    esp.baud(9600);
    socket = false;
}


Huzzah::Huzzah(PinName tx_pin, PinName rx_pin)
    :esp(tx_pin, rx_pin), ssid(""), pwd("")
{
    tx_in=0;
    tx_out=0;
    rx_in=0;
    rx_out=0;
    esp.baud(9600);
    socket = false;
}


void Huzzah::setssid(string s)
{
    ssid = s;
}


void Huzzah::setpwd(string s)
{
    pwd = s;
}


string Huzzah::get_ip()
{            
    strcpy(cmdbuff, "print(wifi.sta.getip())\r\n");
    send_cmd();
    getreply();
    string s(replybuff);
    return s;
}


void Huzzah::open_socket(string host, string port)
{
    pc.printf("opening socket!\r\n");
    string conn("conn:connect(");
    conn += port + "\,\"" + host + "\")\r\n";
    
    sprintf(cmdbuff, "conn=net.createConnection(net.TCP, false)\r\n");
    send_cmd();
    getreply();
    wait(0.2);
    sprintf(cmdbuff, "print(conn)\r\n" );
    send_cmd();
    getreply();
    wait(0.2);
    sprintf(cmdbuff, "conn:on(\"receive\", function(conn, pl) print(pl) end)\r\n");
    send_cmd();
    getreply();
    wait(0.2);
    sprintf(cmdbuff, conn.c_str());
    send_cmd();
    getreply();
    wait(1.0);
    
    this->socket = true;
    pc.printf("socket opened\r\n");
    
}


void Huzzah::http_get(string request, string host, string port)
{

    if (!this->socket) {
        this->open_socket(host, port);
    }

    string r("conn:send(\"");
    r += request + "\")\r\n";
    
    string conn("conn:connect(");
    conn += port + "\,\"" + host + "\")\r\n";
    
    sprintf(cmdbuff, "conn=net.createConnection(net.TCP, false)\r\n");
    send_cmd();
    getreply();
    wait(0.2);
    sprintf(cmdbuff, "print(conn)\r\n" );
    send_cmd();
    getreply();
    wait(0.2);
    sprintf(cmdbuff, "conn:on(\"receive\", function(conn, pl) print(pl) end)\r\n");
    send_cmd();
    getreply();
    wait(0.2);
    sprintf(cmdbuff, conn.c_str());
    send_cmd();
    getreply();
    wait(0.5);

    sprintf(cmdbuff, r.c_str());
    send_cmd();
    wait(0.5);
    send_cmd();
    getreply();
    wait(0.5);

    sprintf(cmdbuff, "conn:close()\r\n");
    send_cmd();
    getreply();
    wait(0.5);
    sprintf(cmdbuff, "conn = nil\r\n");
    send_cmd();
    getreply();

}


void Huzzah::send_cmd()
{
    int i;
    char temp_char;
    bool empty;
    i = 0;
    // Start Critical Section - don't interrupt while changing global buffer variables
    NVIC_DisableIRQ(UART1_IRQn);
    empty = (tx_in == tx_out);
    while ((i==0) || (cmdbuff[i-1] != '\n')) {
        // Wait if buffer full
        if (((tx_in + 1) % buffer_size) == tx_out) {
            // End Critical Section - need to let interrupt routine empty buffer by sending
            NVIC_EnableIRQ(UART1_IRQn);
            while (((tx_in + 1) % buffer_size) == tx_out) {
            }
            // Start Critical Section - don't interrupt while changing global buffer variables
            NVIC_DisableIRQ(UART1_IRQn);
        }
        tx_buffer[tx_in] = cmdbuff[i];
        i++;
        tx_in = (tx_in + 1) % buffer_size;
    }
    if (esp.writeable() && (empty)) {
        temp_char = tx_buffer[tx_out];
        tx_out = (tx_out + 1) % buffer_size;
        // Send first character to start tx interrupts, if stopped
        esp.putc(temp_char);
    }
    // End Critical Section
    NVIC_EnableIRQ(UART1_IRQn);
    return;
}


void Huzzah::getreply()
{
    read_line();
    sscanf(rx_line,replybuff);
}


void Huzzah::read_line()
{
    int i;
    i = 0;
    // Start Critical Section - don't interrupt while changing global buffer variables
    NVIC_DisableIRQ(UART1_IRQn);
    // Loop reading rx buffer characters until end of line character
    while ((i==0) || (rx_line[i-1] != '\r')) {
        // Wait if buffer empty
        if (rx_in == rx_out) {
            // End Critical Section - need to allow rx interrupt to get new characters for buffer
            NVIC_EnableIRQ(UART1_IRQn);
            while (rx_in == rx_out) {
            }
            // Start Critical Section - don't interrupt while changing global buffer variables
            NVIC_DisableIRQ(UART1_IRQn);
        }
        rx_line[i] = rx_buffer[rx_out];
        i++;
        rx_out = (rx_out + 1) % buffer_size;
    }
    // End Critical Section
    NVIC_EnableIRQ(UART1_IRQn);
    rx_line[i-1] = 0;
    return;
}


void Huzzah::espsendcmd()
{
    esp.printf("%s", configsnd);
}


void Huzzah::espgetreply()
{
    Timer t;
    memset(configbuf, '\0', sizeof(configbuf));
    t.start();
    ended=0;
    count=0;
    while(!ended) {
        if(esp.readable()) {
            configbuf[count] = esp.getc();
            count++;
        }
        if(t.read() > timeout) {
            ended = 1;
            t.stop();
            t.reset();
        }
    }
}


void Huzzah::espconfig()
{
    wait(5);
    pc.printf("\f---------- Starting ESP Config ----------\r\n\n");
    pc.printf("---------- Reset & get Firmware ----------\r\n");
    strcpy(configsnd,"node.restart()\r\n");
    espsendcmd();
    timeout=5;
    espgetreply();
    pc.printf(configbuf);

    wait(2);

    pc.printf("\n---------- Get Version ----------\r\n");
    strcpy(configsnd,"print(node.info())\r\n");
    espsendcmd();
    timeout=4;
    espgetreply();
    pc.printf(configbuf);

    wait(3);

    // set CWMODE to 1=Station,2=AP,3=BOTH, default mode 1 (Station)
    pc.printf("\n---------- Setting Mode ----------\r\n");
    strcpy(configsnd, "wifi.setmode(wifi.STATION)\r\n");
    espsendcmd();
    timeout=4;
    espgetreply();
    pc.printf(configbuf);

    wait(2);

    pc.printf("\n---------- Listing Access Points ----------\r\n");
    strcpy(configsnd, "function listap(t) \r\n");
    espsendcmd();
    wait(1);
    strcpy(configsnd, "for k,v in pairs(t) do \r\n");
    espsendcmd();
    wait(1);
    strcpy(configsnd, "print(k..\" : \"..v)\r\n");
    espsendcmd();
    wait(1);
    strcpy(configsnd, "end\r\n");
    espsendcmd();
    wait(1);
    strcpy(configsnd, "end\r\n");
    espsendcmd();
    wait(1);
    strcpy(configsnd, "wifi.sta.getap(listap) \r\n");
    espsendcmd();
    wait(1);
    timeout=15;
    espgetreply();
    pc.printf(configbuf);

    wait(2);

    pc.printf("\n---------- Connecting to AP ----------\r\n");
    pc.printf("ssid = %s   pwd = %s\r\n",ssid.c_str(),pwd.c_str());
    strcpy(configsnd, "wifi.sta.config(\"");
    strcat(configsnd, ssid.c_str());
    strcat(configsnd, "\",\"");
    strcat(configsnd, pwd.c_str());
    strcat(configsnd, "\")\r\n");
    espsendcmd();
    timeout=10;
    espgetreply();
    pc.printf(configbuf);

    wait(10);

    pc.printf("\n---------- Get IP's ----------\r\n");
    strcpy(configsnd, "print(wifi.sta.getip())\r\n");
    espsendcmd();
    timeout=3;
    espgetreply();
    pc.printf(configbuf);

    wait(1);
    return;
}