#include "PubNub.h"


PubNub::PubNub(string pkey, string skey, string channel, PinName tx_pin, PinName rx_pin)
    : pubkey(pkey), subkey(skey), channel(channel), huz(tx_pin, rx_pin)
{
    conn_host = "www.pubsub.pubnub.com";
    conn_port = "80";
}


void PubNub::send_message(string message)
{
    string r("GET /publish/");
    r += pubkey + "/" + subkey + "/0/" + channel + "/0/" + "%%7B%%22text%%22%%3A%%22" +
        message + "%%22%%7D HTTP/1.1\\r\\nHost: www.pubsub.pubnub.com" +
        "\\r\\nConnection: close\\r\\nAccept: */*\\r\\n\\r\\n";
    huz.http_get(r, conn_host, conn_port);
}

void PubNub::send_message(char* message)
{
    string m(message);
    send_message(m);
}