#include "mbed.h"
#include "MBed_Adafruit_GPS.h"
#include "math.h"
#include "PubNub.h"
#include "Watchdog.h"

string pubkey("pub-c-xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
string subkey("sub-c-xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
string channel("biketracker");

PubNub pnub(pubkey, subkey, channel, p28, p27); // tx, rx

int DataRX;
volatile int tx_in;
volatile int tx_out;
volatile int rx_in;
volatile int rx_out;
char tx_buffer[4096];
char rx_buffer[4096];

Watchdog wdt;

Serial * gps_Serial;
Serial pc (USBTX, USBRX); //Set-up for debugging

//Take degree, minute,seconds (DMS) from GPS and convert to decimal degrees (DD) for Pubnub
float dms_convert(float dms)
{
    float sec, min, deg, dd;
    sec = (dms*100)-(floor(dms)*100);
    deg = floor(dms/100);
    min = floor(dms)-(deg*100);
    dd = deg +((min+(sec/60))/60);
    return dd;
}

// Interupt Routine to read in data from serial port
void Rx_interrupt()
{
    DataRX=1;
    // Loop just in case more than one character is in UART's receive FIFO buffer
    // Stop if buffer full
    while ((pnub.huz.esp.readable()) && (((rx_in + 1) % buffer_size) != rx_out)) {
        rx_buffer[rx_in] = pnub.huz.esp.getc();
        // Uncomment to Echo to USB serial to watch data flow
        //pc.putc(rx_buffer[rx_in]);
        rx_in = (rx_in + 1) % buffer_size;
    }
    return;
}


// Interupt Routine to write out data to serial port
void Tx_interrupt()
{
    // Loop to fill more than one character in UART's transmit FIFO buffer
    // Stop if buffer empty
    while ((pnub.huz.esp.writeable()) && (tx_in != tx_out)) {
        pnub.huz.esp.putc(tx_buffer[tx_out]);
        tx_out = (tx_out + 1) % buffer_size;
    }
    return;
}

int main()
{
    wdt.kick(7.0);
    pc.baud(115200); //Set PC baud rate
    
    //Uncomment Below to set-up new network
    /*
    //Update SSID and Password 
    pnub.huz.setssid("Verizon-SM-G900V-258B");
    pnub.huz.setpwd("trnd533)");
    pnub.huz.espconfig();
    */
    
    gps_Serial = new Serial(p9,p10); //tx, rx
    Adafruit_GPS myGPS(gps_Serial); //object of Adafruit's GPS class
    Timer refresh_Timer; //Timer for updated GPS information
    const int refresh_Time = 2000; //refresh time in ms


    //Initialization Commands for Adafruit_GPS
    myGPS.begin(9600);  //sets baud rate for GPS communication;
    myGPS.sendCommand(PMTK_SET_NMEA_OUTPUT_RMCGGA);
    myGPS.sendCommand(PMTK_SET_NMEA_UPDATE_1HZ);
    myGPS.sendCommand(PGCMD_ANTENNA);
    float publat;
    float publong;
    float oldlat = 0.0;
    float oldlong = 0.0;
    char c;

    // Setup a serial interrupt function to receive data
    pnub.huz.esp.attach(&Rx_interrupt, Serial::RxIrq);
    // Setup a serial interrupt function to transmit data
    pnub.huz.esp.attach(&Tx_interrupt, Serial::TxIrq);

    char lat_buff[30];

    pc.printf("Connection established at 115200 baud...\r\n");
    wait(1);
    refresh_Timer.start();  //starts the clock on the timer
    while(true) {
        c = myGPS.read();   //queries the GPS

        //if (c) { pc.printf("%c", c); } //this line will echo the GPS data if not paused
        //If GPS has data, parse it

        //check if we recieved a new message from GPS, if so, attempt to parse it,
        if ( myGPS.newNMEAreceived() ) {
            if ( !myGPS.parse(myGPS.lastNMEA()) ) {
                continue;
            }
        }

        //check if enough time has passed to warrant sending new GPS data
        if (refresh_Timer.read_ms() >= refresh_Time) {
            refresh_Timer.reset();
            if (myGPS.fix) {
                publat = dms_convert(myGPS.latitude);
                publat -= 0.003148; //Manual correction of GPS accuracy
                publong = dms_convert(myGPS.longitude);
                publong -= 0.0077074; //Manual correction of GPS accuracy
                if (publat != oldlat || publong !=oldlong) {
                    //pc.printf("DMS Lat: %f%c, DMS Long: %f%c\r\n",myGPS.latitude, myGPS.lat, myGPS.longitude, myGPS.lon);
                    oldlat = publat;
                    oldlong = publong;
                    DataRX = 0;
                    sprintf(lat_buff, "%f %f", publat, publong);
                    pnub.send_message(lat_buff);
                    pc.printf("Message Sent\r\n");
                    continue;
                } else pc.printf("No New Data\r\n");
            } else {
                pc.printf("No Satelite Fix\r\n");
            }
        }
        wdt.kick();
    }
}