/*
 * File name  : HP20x_dev.cpp
 * Description: Driver for I2C PRECISION BAROMETER AND ALTIMETER [HP206C]
 * Author     : Oliver Wang from Seeed studio
 * Version    : V0.1
 * Create Time: 2014/04
 * Change Log :
*/

/****************************************************************************/
/***        Include files                                                 ***/
/****************************************************************************/
#include "HP20x_dev.h"
#include "mbed.h"
//#include "KalmanFilter.h"
/****************************************************************************/
/***       Local Variable                                                 ***/
/****************************************************************************/



/****************************************************************************/
/***       Class member Functions                                         ***/
/****************************************************************************/
/*
 **@ Function name: HP20x_dev
 **@ Description: Constructor
 **@ Input: none
 **@ OutPut: none
 **@ Retval: none
*/

HP20x_dev::HP20x_dev(PinName p_sda, PinName p_scl) : i2c(p_sda, p_scl) {
   OSR_CFG = HP20X_CONVERT_OSR1024;
   OSR_ConvertTime = 25; 
}


/*
 **@ Function name: begin
 **@ Description: Initialize HP20x_dev
 **@ Input: none
 **@ OutPut: none
 **@ Retval: none
*/
void HP20x_dev::reset()
{
 
  /* Reset HP20x_dev */
  char data_write[1];
  data_write[0] = HP20X_SOFT_RST;
  if ( i2c.write( HP20X_ADDRESS,  data_write, 1,0 ) );
   wait_ms(60);

}

/*
 **@ Function name: isAvailable
 **@ Description: Indicate whether it's available
 **@ Input: none
 **@ OutPut: none
 **@ Retval: uchar 
*/
char HP20x_dev::isAvailable()
{
  char ret = readByte(HP20X_ADDRESS,REG_PARA|HP20X_RD_REG_MODE);//readreg
  return ret;
}



long HP20x_dev::ReadPressure(void)
{
 
  
  writeByte(HP20X_ADDRESS,HP20X_WR_CONVERT_CMD,OSR_CFG);
   
wait_ms(OSR_ConvertTime);

    char data_write[1];
    data_write[0] =  HP20X_READ_P;
  if ( i2c.write( HP20X_ADDRESS,data_write,1,0 ) );
 
    long TempData = 0;
    long tmpArray[3]={0};
    
    
    /* Require three bytes from slave */
   
    char data[3];
   
    data_write[0] = I2C_DID_RD_MASK;
    i2c.write(HP20X_ADDRESS, data_write, 1, 1); // no stop
    i2c.read(HP20X_ADDRESS, data, 3, 0); 
    for(int ii = 0; ii < 3; ii++) {
     tmpArray[ii] = data[ii];}
    
    /* MSB */
    TempData = tmpArray[0]<<16 | tmpArray[1]<<8 | tmpArray[2];

    
    if(TempData&0x800000)
    {
        TempData|=0xff000000;
    }

    return TempData;        
   
} 


void HP20x_dev::writeByte(uint8_t address, uint8_t subAddress, uint8_t data)
    {
       char data_write[2];
       data_write[0] = subAddress;
       data_write[1] = data;
       i2c.write(address, data_write, 2, 0);
    }

char HP20x_dev::readByte(uint8_t address, uint8_t subAddress)
    {
        char data[1]; // `data` will store the register data     
        char data_write[1];
        data_write[0] = subAddress;
        i2c.write(address, data_write, 1, 1); // no stop
        i2c.read(address, data, 1, 0); 
        return data[0]; 
    }



/**************************************END OF FILE**************************************/