

#include "mbed.h"
#include "Adafruit_SEPS114A.h"


#define SEPS114A_SOFT_RESET 0x01
#define SEPS114A_DISPLAY_ON_OFF 0x02
#define SEPS114A_ANALOG_CONTROL 0x0F    //
#define SEPS114A_STANDBY_ON_OFF 0x14
#define SEPS114A_OSC_ADJUST 0x1A
#define SEPS114A_ROW_SCAN_DIRECTION 0x09
#define SEPS114A_DISPLAY_X1 0x30
#define SEPS114A_DISPLAY_X2 0x31
#define SEPS114A_DISPLAY_Y1 0x32
#define SEPS114A_DISPLAY_Y2 0x33
#define SEPS114A_DISPLAYSTART_X 0x38
#define SEPS114A_DISPLAYSTART_Y 0x39
#define SEPS114A_CPU_IF 0x0D
#define SEPS114A_MEM_X1 0x34
#define SEPS114A_MEM_X2 0x35
#define SEPS114A_MEM_Y1 0x36
#define SEPS114A_MEM_Y2 0x37
#define SEPS114A_MEMORY_WRITE_READ 0x1D
#define SEPS114A_DDRAM_DATA_ACCESS_PORT 0x08
#define SEPS114A_DISCHARGE_TIME 0x18
#define SEPS114A_PEAK_PULSE_DELAY 0x16
#define SEPS114A_PEAK_PULSE_WIDTH_R 0x3A
#define SEPS114A_PEAK_PULSE_WIDTH_G 0x3B
#define SEPS114A_PEAK_PULSE_WIDTH_B 0x3C
#define SEPS114A_PRECHARGE_CURRENT_R 0x3D
#define SEPS114A_PRECHARGE_CURRENT_G 0x3E
#define SEPS114A_PRECHARGE_CURRENT_B 0x3F
#define SEPS114A_COLUMN_CURRENT_R 0x40
#define SEPS114A_COLUMN_CURRENT_G 0x41
#define SEPS114A_COLUMN_CURRENT_B 0x42
#define SEPS114A_ROW_OVERLAP 0x48
#define SEPS114A_SCAN_OFF_LEVEL 0x49
#define SEPS114A_ROW_SCAN_ON_OFF 0x17
#define SEPS114A_ROW_SCAN_MODE 0x13
#define SEPS114A_SCREEN_SAVER_CONTEROL 0xD0
#define SEPS114A_SS_SLEEP_TIMER 0xD1
#define SEPS114A_SCREEN_SAVER_MODE 0xD2
#define SEPS114A_SS_UPDATE_TIMER 0xD3
#define SEPS114A_RGB_IF 0xE0
#define SEPS114A_RGB_POL 0xE1
#define SEPS114A_DISPLAY_MODE_CONTROL 0xE5



void Adafruit_SEPS114A::set_region(int x, int y, int xs, int ys)
{
  // draw region
  writeCommand(SEPS114A_MEM_X1,x);
  writeCommand(SEPS114A_MEM_X2,x+xs-1);
  writeCommand(SEPS114A_MEM_Y1,y);
  writeCommand(SEPS114A_MEM_Y2,y+ys-1);
  // start position
   writeCommand(SEPS114A_DISPLAYSTART_X,x);
   writeCommand(SEPS114A_DISPLAYSTART_Y,y); 
}

void Adafruit_SEPS114A::begin(void)//oled init
{
  
 
	rst = 0;
    // wait 10ms
    wait_ms(10);
    // bring out of reset
    rst = 1;
    // turn on VCC (13V?)
	wait_ms(10);
    				/*  Soft reser */
                   writeCommand(SEPS114A_SOFT_RESET,0x00);      
                   /* Standby ON/OFF*/
                   writeCommand(SEPS114A_STANDBY_ON_OFF,0x01);          // Standby on
                   wait_ms(5);                                           // Wait for 5ms (1ms Delay Minimum)
                   writeCommand(SEPS114A_STANDBY_ON_OFF,0x00);          // Standby off
                   wait_ms(5);                                           // 1ms Delay Minimum (1ms Delay Minimum)
                   /* Display OFF */
                   writeCommand(SEPS114A_DISPLAY_ON_OFF,0x00);
                   /* Set Oscillator operation */
                   writeCommand(SEPS114A_ANALOG_CONTROL,0x40);          // using external resistor and internal OSC
                   /* Set frame rate */
                   writeCommand(SEPS114A_OSC_ADJUST,0x03);              // frame rate : 95Hz
             
                   /* Select the RGB data format and set the initial state of RGB interface port */
                  writeCommand(SEPS114A_RGB_IF,0x00);                 //0xE0   RGB 8bit interface
                   /* Set RGB polarity */
                   writeCommand(SEPS114A_RGB_POL,0x00);
                   /* Set display mode control */
                   writeCommand(SEPS114A_DISPLAY_MODE_CONTROL,0x80);   // SWAP:BGR, Reduce current : Normal, DC[1:0] : Normal
                  
                   /* Set MCU Interface */
                   writeCommand(SEPS114A_CPU_IF,0x00);                 // MPU External interface mode, 8bits
                   /* Set Memory Read/Write mode */
                   writeCommand(SEPS114A_MEMORY_WRITE_READ,0x00);
                   /* Set row scan direction */
                  // writeCommand(SEPS114A_ROW_SCAN_DIRECTION,0x00);     // Column : 0 --> Max, Row : 0 Ѓ--> Max
                    writeCommand(SEPS114A_ROW_SCAN_DIRECTION,0x02);     // Column : 0 --> Max, Row : 0 Ѓ--> Max
                   /* Set row scan mode */
                   writeCommand(SEPS114A_ROW_SCAN_MODE,0x00);          // Alternate scan mode
                   /* Set column current */
                                
                  // writeCommand(SEPS114A_COLUMN_CURRENT_R,0x32);
                  // writeCommand(SEPS114A_COLUMN_CURRENT_G,0x31);
                  // writeCommand(SEPS114A_COLUMN_CURRENT_B,0x31);
                  writeCommand(SEPS114A_COLUMN_CURRENT_R,0x6E);
                  writeCommand(SEPS114A_COLUMN_CURRENT_G,0x4F);
                  writeCommand(SEPS114A_COLUMN_CURRENT_B,0x77);
                  
                   /* Set row overlap */
                   writeCommand(SEPS114A_ROW_OVERLAP,0x00);            // Band gap only
                   /* Set discharge time */
                   writeCommand(SEPS114A_DISCHARGE_TIME,0x01);         // Discharge time : normal discharge
                   /* Set peak pulse delay */
                   writeCommand(SEPS114A_PEAK_PULSE_DELAY,0x00);
                   /* Set peak pulse width */
                   writeCommand(SEPS114A_PEAK_PULSE_WIDTH_R,0x02);
                   writeCommand(SEPS114A_PEAK_PULSE_WIDTH_G,0x02);
                   writeCommand(SEPS114A_PEAK_PULSE_WIDTH_B,0x02);
                   /* Set precharge current */
                   
                   writeCommand(SEPS114A_PRECHARGE_CURRENT_R,0x14);
                   writeCommand(SEPS114A_PRECHARGE_CURRENT_G,0x50);
                   writeCommand(SEPS114A_PRECHARGE_CURRENT_B,0x19);
                   
                          
                   /* Set row scan on/off  */
                   writeCommand(SEPS114A_ROW_SCAN_ON_OFF,0x00);        // Normal row scan
                   /* Set scan off level */
                   writeCommand(SEPS114A_SCAN_OFF_LEVEL,0x04);         // VCC_C*0.75 //0x04
                  
                   writeCommand(SEPS114A_MEM_X1,0x00);
                   writeCommand(SEPS114A_MEM_X2,0x5F);
                   writeCommand(SEPS114A_MEM_Y1,0x00);
                   writeCommand(SEPS114A_MEM_Y2,0x5F);                 
                   
                   /* Set memory access point */
                   
                   writeCommand(SEPS114A_DISPLAYSTART_X,0x00);
                   writeCommand(SEPS114A_DISPLAYSTART_Y,0x00);
                   
                  // set_region(0, 0, 96, 96); 
                         /* Set active display area of panel */
                   writeCommand(SEPS114A_DISPLAY_X1,0x00);
                   writeCommand(SEPS114A_DISPLAY_X2,0x5F);
                   writeCommand(SEPS114A_DISPLAY_Y1,0x00);
                   writeCommand(SEPS114A_DISPLAY_Y2,0x5F);
                   
                   /* Display ON */
                   writeCommand(SEPS114A_DISPLAY_ON_OFF,0x01);
}



//Set memory area(address) to write a display data
void Adafruit_SEPS114A::MemorySize(uint8_t X1, uint8_t X2, uint8_t Y1, uint8_t Y2){
    writeCommand(SEPS114A_MEM_X1,X1);
    writeCommand(SEPS114A_MEM_X2,X2);
    writeCommand(SEPS114A_MEM_Y1,Y1);
    writeCommand(SEPS114A_MEM_Y2,Y2);
}

uint16_t Adafruit_SEPS114A::Color565(uint8_t r, uint8_t g, uint8_t b) {
  uint16_t c;
  c = r >> 3;
  c <<= 6;
  c |= g >> 2;
  c <<= 5;
  c |= b >> 3;

  return c;
}


// Set a single pixel
void Adafruit_SEPS114A::drawPixel(int16_t x, int16_t y, uint16_t color)
{
		   if ((x < 0) || (x >= width()) || (y < 0) || (y >= height()))  // Bounds check.
        return;
    
    // check rotation, move pixel around if necessary
    switch (getRotation())
    {
        case 1:  							// Rotated 90 degrees clockwise.
            swap(x, y);
            x = _rawWidth - x - 1;
            break;
        case 2:								// Rotated 180 degrees clockwise.
            x = _rawWidth - x - 1;
            y = _rawHeight - y - 1;
            break;
        case 3:								// Rotated 270 degrees clockwise.
            swap(x, y);
            y = _rawHeight - y - 1;
            break;
    }  
    
	MemorySize( x,  1,  y,  1);
	DDRAM_access();
	writeData(color >> 8) ;
	writeData(color);	
}


void Adafruit_SEPS114A::clearDisplay()
{
    int j;
    MemorySize(0x00,0x5F,0x00,0x5F);
    DDRAM_access();
    
    for(j=0;j<9216;j++){                        // 
    				writeData(Black >> 8) ;
					writeData(Black);           
                       }
}

 void Adafruit_SEPS114A::setContrastControl(int brightness)
{
    int r, g, b;
        r = 2 + 16*brightness;
        g = 1 + 10*brightness;
        b = 1 + (23*brightness)/2;
        writeCommand(SEPS114A_COLUMN_CURRENT_R,r);
        writeCommand(SEPS114A_COLUMN_CURRENT_G,g);
        writeCommand(SEPS114A_COLUMN_CURRENT_B,b);
}
  







