/*************************************************** 
  This is a library for the 1.5" & 1.27" 16-bit Color OLEDs 
  with SSD1331 driver chip

  Pick one up today in the adafruit shop!
  ------> http://www.adafruit.com/products/1431
  ------> http://www.adafruit.com/products/1673

  These displays use SPI to communicate, 4 or 5 pins are required to  
  interface
  Adafruit invests time and resources providing this open source code, 
  please support Adafruit and open-source hardware by purchasing 
  products from Adafruit!

  Written by Limor Fried/Ladyada for Adafruit Industries.  
  BSD license, all text above must be included in any redistribution
 ****************************************************/



//#ifndef _ADAFRUIT_SSD1351_H_
//#define _ADAFRUIT_SSD1351_H_

#include "mbed.h"
#include "Adafruit_GFX.h"

#include <vector>
#include <algorithm>






/* some 16bit RGB color definitions  */
enum Color{                                             
 Black           = 0x0000,      /*   0,   0,   0 */
 Navy            = 0x000F,      /*   0,   0, 128 */
 DarkGreen       = 0x03E0,      /*   0, 128,   0 */
 DarkCyan        = 0x03EF,      /*   0, 128, 128 */
 Maroon          = 0x7800,      /* 128,   0,   0 */
 Purple          = 0x780F,      /* 128,   0, 128 */
 Olive           = 0x7BE0,      /* 128, 128,   0 */
 LightGrey       = 0xC618,      /* 192, 192, 192 */
 DarkGrey        = 0x7BEF,      /* 128, 128, 128 */
 Blue            = 0x001F,      /*   0,   0, 255 */
 Green           = 0x07E0,      /*   0, 255,   0 */
 Cyan            = 0x07FF,      /*   0, 255, 255 */
 Red             = 0xF800,      /* 255,   0,   0 */
 Magenta         = 0xF81F,      /* 255,   0, 255 */
 Yellow          = 0xFFE0,      /* 255, 255,   0 */
 White           = 0xFFFF,      /* 255, 255, 255 */
 Orange          = 0xFD20,      /* 255, 165,   0 */
 GreenYellow     = 0xAFE5,      /* 173, 255,  47 */
 Pink            = 0xF81F
};


// A DigitalOut sub-class that provides a constructed default state
class DigitalOut2 : public DigitalOut
{
public:
	DigitalOut2(PinName pin, bool active = false) : DigitalOut(pin) { write(active); };
	DigitalOut2& operator= (int value) { write(value); return *this; };
	DigitalOut2& operator= (DigitalOut2& rhs) { write(rhs.read()); return *this; };
	operator int() { return read(); };
};




/** The pure base class for the SSD1351 display driver.
 *
 
 */
class Adafruit_SSD1351 : public Adafruit_GFX
{
public:
	Adafruit_SSD1351(PinName RST, uint8_t rawHeight = 96, uint8_t rawWidth = 128)
		: Adafruit_GFX(rawWidth,rawHeight)
		, rst(RST,false)
	{
		
		
		
	};

	void begin();
	void goTo(int x, int y);
	uint16_t Color565(uint8_t r, uint8_t g, uint8_t b);
	virtual void fillScreen(uint16_t fillcolor);
	virtual void rawFillRect(uint16_t x, uint16_t y, uint16_t w, uint16_t h, uint16_t fillcolor);
	void fillRect(uint16_t x, uint16_t y, uint16_t w, uint16_t h, uint16_t fillcolor);
	void rawFastHLine(int16_t x, int16_t y, int16_t w, uint16_t color);
	void rawFastVLine(int16_t x, int16_t y, int16_t h, uint16_t color);
	virtual void drawFastVLine(int16_t x, int16_t y, int16_t h, uint16_t color);
	virtual void drawFastHLine(int16_t x, int16_t y, int16_t w, uint16_t color);
	void setContrastControl(uint8_t contrast);
	
	
	virtual void  invert(bool v); 
	
	
	// These must be implemented in the derived transport driver
	virtual void writeCommand(uint8_t c) = 0;
	virtual void writeData(uint8_t c) = 0;
	virtual void drawPixel(int16_t x, int16_t y, uint16_t color);

    
protected:
	
	DigitalOut2 rst;



};


/** This is the SPI SSD1351 display driver transport class
 *
 */
class Adafruit_SSD1351_Spi : public Adafruit_SSD1351
{
public:
	/** Create a SSD1351 SPI transport display driver instance with the specified DC, RST, and CS pins, as well as the display dimentions
	 *
	 * Required parameters
	 * @param spi - a reference to an initialized SPI object
	 * @param DC (Data/Command) pin name
	 * @param RST (Reset) pin name
	 * @param CS (Chip Select) pin name
	 *
	 * Optional parameters
	 * @param rawHeight - the vertical number of pixels for the display, defaults to 96
	 * @param rawWidth - the horizonal number of pixels for the display, defaults to 128
	 */
	Adafruit_SSD1351_Spi(SPI &spi, PinName DC, PinName RST, PinName CS, uint8_t rawHieght = 96, uint8_t rawWidth = 128)
	    : Adafruit_SSD1351(RST, rawHieght, rawWidth)
	    , cs(CS,true)
	    , dc(DC,false)	  
	    , mspi(spi)
	    {
		    begin();
		   
		  
	    };

	virtual void writeCommand(uint8_t c)
	{
	   
	    dc = 0;	  
	    cs = 0;
	    mspi.write(c);
	    cs = 1;
	};

	virtual void writeData(uint8_t c)
	{
	    
	    dc = 1;	  
	    cs = 0;
	
       mspi.write(c);
	 
	    cs = 1;
	};


protected:
	
	DigitalOut2 cs, dc;
	SPI &mspi;
};

