#include "mbed.h"

/*
通过IO口直接控制ULN2003来驱动电机正反转,这是测试程序.
运行后,电机先开始:正向加速->然后正向匀速转动一段时间->正向减速直到停止;-> 反向加速->然后反向匀速转动一段时间->反向减速直到停止;如此不断往复.
*/

DigitalOut STEP_A(A2);
DigitalOut STEP_B(A3);
DigitalOut STEP_C(A4);
DigitalOut STEP_D(A5);

unsigned char FFZ[8]={0x01,0x03,0x02,0x06,0x04,0x0c,0x08,0x09}; //正转
unsigned char FFW[8]={0x09,0x08,0x0c,0x04,0x06,0x02,0x03,0x01}; //反转

unsigned char index = 0;

void  motor_ff(unsigned char dir, float dly)
{ 
    unsigned char status;
    
    index %= 8;
    
    if (dir == 0)
    {
        status = FFZ[index] & 0x1f;
    }
    else
    {
        status = FFW[index] & 0x1f;
    }

    index++;
    
    ((status & 0x01) == 0) ? (STEP_A = 0): (STEP_A = 1);
    ((status & 0x02) == 0) ? (STEP_B = 0): (STEP_B = 1);
    ((status & 0x04) == 0) ? (STEP_C = 0): (STEP_C = 1);
    ((status & 0x08) == 0) ? (STEP_D = 0): (STEP_D = 1);
    
    wait(dly);
} 

void dyl()
{
    wait(0.03);//1/8起始频率 0.08,0.01,0.009,0.008,0.004,0.002,0.001,0.0009极限(5V); (10V)0.0008
}

//float cycles_5v[] = {0.08, 0.07, 0.06, 0.05, 0.04, 0.03,};//0.08->...->0.01->...->0.001->...->0.0009->0.0009->...->0.001->...->0.08
double cycles_5v;
double cycles_5v_start = 0.01;//0.08;
double cycles_5v_avg = 0.0009;
double cycles_5v_step = 0.0001;

/*
通过IO口直接控制ULN2003来驱动电机正反转,这是测试程序.
运行后,电机先开始:正向加速->然后正向匀速转动一段时间->正向减速直到停止;-> 反向加速->然后反向匀速转动一段时间->反向减速直到停止;如此不断往复.
*/
int main()
{
        cycles_5v = cycles_5v_start;
    
        unsigned int count = 0;
    
    while(1)
    {
            /* 正转 */
            //加速
            do
            {
                count = 10;
                do
                {
                    motor_ff(0, cycles_5v);
                    count--;
                }while(count>1);
                cycles_5v = cycles_5v - cycles_5v_step;
            }while(cycles_5v > (cycles_5v_avg + cycles_5v_step));
        
            //匀速
            cycles_5v = cycles_5v_avg;
            count = 65535;
            do
            {
                motor_ff(0, cycles_5v);
                count--;
            }while(count>1);
            
            //减速
            do
            {
                count = 10;
                do
                {
                    motor_ff(0, cycles_5v);
                    count--;
                }while(count>1);
                cycles_5v = cycles_5v + cycles_5v_step;
            }while(cycles_5v < (cycles_5v_start - cycles_5v_step));
            
            
            /* 反转 */
            //加速
            do
            {
                count = 10;
                do
                {
                    motor_ff(1, cycles_5v);
                    count--;
                }while(count>1);
                cycles_5v = cycles_5v - cycles_5v_step;
            }while(cycles_5v > (cycles_5v_avg + cycles_5v_step));
        
            //匀速
            cycles_5v = cycles_5v_avg;
            count = 65535;
            do
            {
                motor_ff(1, cycles_5v);
                count--;
            }while(count>1);
            
            //减速
            do
            {
                count = 10;
                do
                {
                    motor_ff(1, cycles_5v);
                    count--;
                }while(count>1);
                cycles_5v = cycles_5v + cycles_5v_step;
            }while(cycles_5v < (cycles_5v_start - cycles_5v_step));
    }
}
