#ifndef JSMN_UTILS_H
#define JSMN_UTILS_H

#include "jsmn.h"
#include <stdlib.h>
#include <stdbool.h>

void    jsmn_error(int err_code);

// Getters (if the token is an array, it uses idx)
jsmntok_t*    jsmn_get_token(char* json_string, jsmntok_t* token, char* target);

void          jsmn_get_string(char* json_string, jsmntok_t* token, char* target, int idx, char* dest);
int           jsmn_get_integer(char* json_string, jsmntok_t* token, char* target, int idx);
unsigned long jsmn_get_ulong(char* json_string, jsmntok_t* token, char* target, int idx);
bool          jsmn_get_boolean(char* json_string, jsmntok_t* token, char* target, int idx);

void          jsmn_get_integer_array(char* json_string, jsmntok_t* token, char* target, int* destination);
void          jsmn_get_ulong_array(char* json_string, jsmntok_t* token, char* target, unsigned long* destination);
void          jsmn_get_boolean_array(char* json_string, jsmntok_t* token, char* target, bool* destination);

size_t        jsmn_get_string_length(char* json_string, jsmntok_t* token, char *target, int idx);

// Printers
jsmntok_t* jsmn_print_token(char *json_string, jsmntok_t *token);
void       jsmn_print_object(char *json_string);

#endif