#include "mbed.h"

#include "types.h"
#include "curl.c"
#include "converter.c"

DigitalOut myled(LED1);

int main() {
    
    char tx1[] = "NIUQMEASDHOI9OOZQYZHTYTWZTICMPMXANKILWPSM9EGSQGWPLOVLXZPHLRPWWRARCZJRTCAVXCALGPTO9RNHKBDRRDSF9QBKKAUJMLRSCPDBXTKJIAKLO9YMIJARKPNYPRXTEW9FGHJVNWPIQ9TXIXWJBZDYMIDWPLQKKMLH9C9PKHYNMD9M9XIWEIRHQPLVADNNLMC9VPIRLVTQOURSRPWKGHAPAYPOWPNRKVKLJHFDKTAVVHBTWYZWJFJJIWYAQRSOJCOJYNQCR9JTZAEND9JUOXSACPYH9VETKWIJIPRHUGOZASVWZEHIYTABQZEPFFOFR9QPSJQPEMQQECIOJ9GITMOYGUEFYILWIPWGFRNNUWMDPLAFZGAZQGH9AWDCAEXZJNJDKNWVPLKGAVKIE9OWAEQ9RLZFYKK9XVJMXNIOOSQNKXTQAZHAVMLUQOGUWLOEH9FQCEJXLLTXZAYBNKUFRBAGDBMUWHI9XVDOAA9WFMWQF9DGYSKZO9PH9DQLMTLIVYLDMZYKGZNMYZDPHFDMRFYD9JILGVBSFYKRWJRRZCLUY9CNSOKYNZYUANAWO9KZIUGRKAYRDFR9CYZFYUCGGLLHGTCNNXTVKPHKFOASSYBDIZNJMYNVCEGWM9AAASZHXDYMOZWWJHVZOLLKDPOYARQUZNFCDYOCY9UHNUUKXLDMNMLQSMNBPBFLVZ9YZRP9JRJUPTGEMVKUIOOERTTLLSJSLVELKGY9GSTMKTZBBDUXCGYTUQLDOTNYWFWSRDTWFJEADPOZRANJGZEQEXWFJZDCLECOSFHFIZJRNBFDMPOAYPLNPZCL9STISUKUKEOWZVXCDCWXJDLHMAPOFOBAJJPCKNZOLBQVOOOMQQUXSC9EYH9NDJIUWRUYZAFCZ9AWUSRFJVWTARKCDHWHRHAPMNBZHDBIZIUJRZJYYUEBU9TOXQYSRHHHOOHLOZJCDTSYQZWJFBVDISDICWFEQKBWDPCXVJDPQVOGGW9PGOHDVWDDYLBMESPRHUWAGHGFBWT9X9DVZSDUKDAFRESFCHXFEMOWNQVMKRHFPLMNRNYAMIXIJAXUNZKOOAWNPVEEKWORSCOBODVOEQCFPPENQIVAUQHN9DHAUR9DWQHLRJEBDAQXDDZWCPMW99TCNPWYZSHBGQZU9ODANVSMIGMIAJIJH9DEVUCNTT9VIFKCSSUPMKKPZPZVUWGTYGAHSFTNCEGBGVWMNZHOTVAVDVRMXQEYIYLPZQ9JWTDWKEMMCBXQ9TSPBAMXKKMNDCUHLSSFTJSFMALDXLRIXVVKGLAIQXHYRORVMAWWLTTVKQIGYEMTDBVROSPIRV99KBHFGYGVHZWTLUGHVSRXGXMDIXSNMNZAJCTUXUOEVOOUPJA9MUCSKYSFSN9NMMGNRVVM9VXABKXFSTIGHGZPHPIESWVXBZL9ESJNZWSEWTGTCLZMXFVTALPFXFMEPONJWDGTHBYSNJDMYRSXLL9CWHNR9FJANWSLIHFHSHHLOWX9WGPXRPSSAFRW9JJCIADCIJYZE9FQGZU9ARDEUSYNUVTJLMEWLS9REBNHIFVR99VPNGKOHCLWSRMLXHMIJJZFWXKMMLBDMJLGCILAPFWPFXLW9T9VFY9DVYRIQYQ9BLVQVNHBLKYVMPUJVSTHXCMEXAFOSXJDZHUFOE9QHKIOINEQIUUYHHOYSLGNRGIAELNTVH9UXQTC9HVJXFQPNBTLCYEUCEMPKXLRWSUKEPELNWUCWEYANGIKOYQV9MTPEUWNRHMGGHCDUIMYOBIVULBEZGIWGYFFM9EMVFLHVYIGIAFDRIUGNWLVMWIO9LQN9TABBQDXX9DVJLWKBHSOYY9KMWELYZKNYAPBBHTGWRAOLYLSZPIQCJXCHQFDUWYNOQNKUCZKC9TGMNACBTJPIRZDDAYNPPNZJBV9CFWUYKEBJUJ9NCFGZJHPKTQCVAISKRASBDRBTZLQVXISDR9IYYBEFUVQJCZBNDZKWKVPHOYKBZIQSMDEOIEEKYMDMK9EFFAEZ9JGE9HPJZFRQRBI9YNMNXCXR9CUBVVRGY9YICLSYGFNZHZRDEWSGRBYQGLP99JJMYMUVGBYDWURCNUAPBYRVODVOJJSFRYOEDFVLAAEKVWSNFLIAIRVC9GJDTV9GT9UGMSPKGQNIQKICFPIPBC9HMUTOKGLOYWYUDYVMJHIWDVVXIPEZWFOJIISVTPAESMHCJJAOGFVXNXYLUJWOWVPICQDK9SXPGOLHJGBFZQSASHVFBEQFTYVMWEQAIMODCUMDBWYJRWPJJJYDLNOMOEAD9JLZPFLRMQPWLSSCMIJVCTVCEUYDFXIAOQNZTNJVMYCTHOFBPUSMMJFDE9MWOJD9NAZZHIRCVGSHVYYSYLMFUUQVPKVXRPEIDCGNQSCMFWYMVTHHVVZHMLLCYQASZL9JLEGVSSOAOPV9KEZDCTMUBFLGXZKGKNWPQFQIVSJWTQQDDILZJBDREQRQZPXKNQLOU9JB9YNUQMQGQLIEUOZAVYUJJJBKYMXNJSOIWRXTHBVCCEDYOACXDVOEKEHOZ9JKAGCLQRETGODRRSUICOCOMCEJSNPVATINXGGFLNEZWRTUYNQPJBUXNXSJVRPONGLYZGPZKFIORXISXXTVFFYJEYINQOUJAQCDBUAQCSPGDZEOBFCLEEJUZ9S";
    
    CURL_OBJ curl;
    curl_initialize(&curl);
    
    trit_t tx_trits[8019];
    chars_to_trits(tx1, tx_trits, strlen(tx1));
    curl_absorb(&curl, tx_trits, 8019);
    
    trit_t hash_trits[243];
    curl_squeeze_chunk(&curl, hash_trits);
    
    char hash[81];
    trits_to_chars(hash_trits, hash, 243);
    
    //printf("Real hash:\r\n%s\r\n", hash1);
    printf("Computed hash:\r\n%.*s\r\n", 81, hash);
    
    while(1) {
        myled = 1; // LED is ON
        wait(0.2); // 200 ms
        myled = 0; // LED is OFF
        wait(1.0); // 1 sec
    }
}
