#ifndef CURL_H
#define CURL_H

#include "./types.h"

/* INPUT
    L'input della funzione Curl deve essere un array di trit di lunghezza
    multipla di 243
*/
/* OUTPUT
    L'output sarà un array di trit di lunghezza multipla di 243, generato blocco
    per blocco dalla funzione di squeezing
    In particolare l'hash di una transazione sarà un unico blocco di 243 trits
*/

#define HASH_SIZE  243
#define CHUNK_SIZE 243
#define STATE_SIZE 729

#define TR_ROUNDS  81

/* CURL_OBJ
    state:      stato della spugna
    scratchpad: utilizzato durante l'applicazione della funzione di trasformazione
    indices:    array di indici utilizzato per simulare una permutazione
    sub_table:  array che rappresenta la tabella di sostituzione applicata durante
                la trasformazione
                
    x = primo trit in input
    y = secondo trit in input
    
    Substitution table:
        y:  -1, 0, 1
    x: -1   [1, 1, -1]
    x:  0   [0, -1, 1]
    x:  1   [-1, 0, 0]
    
*/
typedef struct CURL_OBJ{
    trit_t  state[STATE_SIZE];
    trit_t  scratchpad[2*STATE_SIZE];
    int16_t indices[STATE_SIZE];
    trit_t  sub_table[9];
} CURL_OBJ;

void curl_initialize(CURL_OBJ *curl);
void curl_reset(CURL_OBJ *curl);
void curl_absorb_chunk(CURL_OBJ *curl, trit_t *in_chunk);
void curl_absorb(CURL_OBJ *curl, trit_t *in_trits, int length);
void curl_squeeze_chunk(CURL_OBJ *curl, trit_t *out_chunk);
void curl_squeeze(CURL_OBJ *curl, trit_t *out_trits, int length);
void curl_transform(CURL_OBJ *curl);

# endif // CURL_H