#ifndef CURL_C
#define CURL_C

#include <string.h>

#include "./curl.h"

#include "./common.h"
#include "./types.h"

void
curl_initialize(CURL_OBJ *curl)
{
    memset(curl,0,sizeof(CURL_OBJ));
    int16_t ind[] = {
        364, 728, 363, 727, 362, 726, 361, 725, 360, 724, 359, 723, 358, 722, 357, 721, 356, 720, 355,
        719, 354, 718, 353, 717, 352, 716, 351, 715, 350, 714, 349, 713, 348, 712, 347, 711, 346, 710,
        345, 709, 344, 708, 343, 707, 342, 706, 341, 705, 340, 704, 339, 703, 338, 702, 337, 701, 336,
        700, 335, 699, 334, 698, 333, 697, 332, 696, 331, 695, 330, 694, 329, 693, 328, 692, 327, 691,
        326, 690, 325, 689, 324, 688, 323, 687, 322, 686, 321, 685, 320, 684, 319, 683, 318, 682, 317,
        681, 316, 680, 315, 679, 314, 678, 313, 677, 312, 676, 311, 675, 310, 674, 309, 673, 308, 672,
        307, 671, 306, 670, 305, 669, 304, 668, 303, 667, 302, 666, 301, 665, 300, 664, 299, 663, 298,
        662, 297, 661, 296, 660, 295, 659, 294, 658, 293, 657, 292, 656, 291, 655, 290, 654, 289, 653,
        288, 652, 287, 651, 286, 650, 285, 649, 284, 648, 283, 647, 282, 646, 281, 645, 280, 644, 279,
        643, 278, 642, 277, 641, 276, 640, 275, 639, 274, 638, 273, 637, 272, 636, 271, 635, 270, 634,
        269, 633, 268, 632, 267, 631, 266, 630, 265, 629, 264, 628, 263, 627, 262, 626, 261, 625, 260,
        624, 259, 623, 258, 622, 257, 621, 256, 620, 255, 619, 254, 618, 253, 617, 252, 616, 251, 615,
        250, 614, 249, 613, 248, 612, 247, 611, 246, 610, 245, 609, 244, 608, 243, 607, 242, 606, 241,
        605, 240, 604, 239, 603, 238, 602, 237, 601, 236, 600, 235, 599, 234, 598, 233, 597, 232, 596,
        231, 595, 230, 594, 229, 593, 228, 592, 227, 591, 226, 590, 225, 589, 224, 588, 223, 587, 222,
        586, 221, 585, 220, 584, 219, 583, 218, 582, 217, 581, 216, 580, 215, 579, 214, 578, 213, 577,
        212, 576, 211, 575, 210, 574, 209, 573, 208, 572, 207, 571, 206, 570, 205, 569, 204, 568, 203,
        567, 202, 566, 201, 565, 200, 564, 199, 563, 198, 562, 197, 561, 196, 560, 195, 559, 194, 558,
        193, 557, 192, 556, 191, 555, 190, 554, 189, 553, 188, 552, 187, 551, 186, 550, 185, 549, 184,
        548, 183, 547, 182, 546, 181, 545, 180, 544, 179, 543, 178, 542, 177, 541, 176, 540, 175, 539,
        174, 538, 173, 537, 172, 536, 171, 535, 170, 534, 169, 533, 168, 532, 167, 531, 166, 530, 165,
        529, 164, 528, 163, 527, 162, 526, 161, 525, 160, 524, 159, 523, 158, 522, 157, 521, 156, 520,
        155, 519, 154, 518, 153, 517, 152, 516, 151, 515, 150, 514, 149, 513, 148, 512, 147, 511, 146,
        510, 145, 509, 144, 508, 143, 507, 142, 506, 141, 505, 140, 504, 139, 503, 138, 502, 137, 501,
        136, 500, 135, 499, 134, 498, 133, 497, 132, 496, 131, 495, 130, 494, 129, 493, 128, 492, 127,
        491, 126, 490, 125, 489, 124, 488, 123, 487, 122, 486, 121, 485, 120, 484, 119, 483, 118, 482,
        117, 481, 116, 480, 115, 479, 114, 478, 113, 477, 112, 476, 111, 475, 110, 474, 109, 473, 108,
        472, 107, 471, 106, 470, 105, 469, 104, 468, 103, 467, 102, 466, 101, 465, 100, 464, 99,  463,
        98,  462, 97,  461, 96,  460, 95,  459, 94,  458, 93,  457, 92,  456, 91,  455, 90,  454, 89,
        453, 88,  452, 87,  451, 86,  450, 85,  449, 84,  448, 83,  447, 82,  446, 81,  445, 80,  444,
        79,  443, 78,  442, 77,  441, 76,  440, 75,  439, 74,  438, 73,  437, 72,  436, 71,  435, 70,
        434, 69,  433, 68,  432, 67,  431, 66,  430, 65,  429, 64,  428, 63,  427, 62,  426, 61,  425,
        60,  424, 59,  423, 58,  422, 57,  421, 56,  420, 55,  419, 54,  418, 53,  417, 52,  416, 51,
        415, 50,  414, 49,  413, 48,  412, 47,  411, 46,  410, 45,  409, 44,  408, 43,  407, 42,  406,
        41,  405, 40,  404, 39,  403, 38,  402, 37,  401, 36,  400, 35,  399, 34,  398, 33,  397, 32,
        396, 31,  395, 30,  394, 29,  393, 28,  392, 27,  391, 26,  390, 25,  389, 24,  388, 23,  387,
        22,  386, 21,  385, 20,  384, 19,  383, 18,  382, 17,  381, 16,  380, 15,  379, 14,  378, 13,
        377, 12,  376, 11,  375, 10,  374, 9,   373, 8,   372, 7,   371, 6,   370, 5,   369, 4,   368,
        3,   367, 2,   366, 1,   365, 0
    };
    for(int i = 0; i < 729; i++) *(curl->indices + i) = ind[i];

    int8_t table[] = {1, 1, -1, 0, -1, 1, -1, 0, 0};
    for(int i = 0; i < 9; i++) *(curl->sub_table + i) = table[i];
}

void
curl_reset(CURL_OBJ *curl)
{
    memset(curl->state,0,STATE_SIZE);
}

void
curl_absorb_chunk(CURL_OBJ *curl, trit_t *in_chunk)
{
    memcpy(curl->state,in_chunk,CHUNK_SIZE);
    curl_transform(curl);
}

void
curl_absorb(CURL_OBJ *curl, trit_t *in_trits, int length)
{
    if(length%CHUNK_SIZE>0) {
        THROW(CURL_ABSORB_INVALID_LENGTH);
    }

    for(int i = 0; i < length/CHUNK_SIZE; i++) {
        curl_absorb_chunk(curl, in_trits + CHUNK_SIZE*i);
    }
}

void
curl_squeeze_chunk(CURL_OBJ *curl, trit_t *out_chunk)
{
    memcpy(out_chunk,curl->state,CHUNK_SIZE);
    curl_transform(curl);
}

void
curl_squeeze(CURL_OBJ *curl, trit_t *out_trits, int length)
{
    if(length%CHUNK_SIZE>0) {
        THROW(CURL_SQUEEZE_INVALID_LENGTH);
    }

    for(int i = 0; i < length/CHUNK_SIZE; i++) {
        curl_squeeze_chunk(curl,out_trits + CHUNK_SIZE*i);
    }
}

void
curl_transform(CURL_OBJ *curl)
{
    trit_t curr, prev;

    // First round of transformation: from state to scratchpad
    prev = curl->state[0];
    for(int i = 0; i < STATE_SIZE; i++) {
        curr = curl->state[curl->indices[i]];
        curl->scratchpad[i] = curl->sub_table[3*prev + curr + 4];
        prev = curr;
    }

    // Rounds 2 to 80: scratchpads
    for(int r = 0; r < TR_ROUNDS-2; r++) {
        prev = curl->scratchpad[(r%2)*STATE_SIZE];
        for(int i = 0; i < STATE_SIZE; i++) {
            curr = curl->scratchpad[(r%2)*STATE_SIZE + curl->indices[i]];
            curl->scratchpad[(1-(r%2))*STATE_SIZE + i] =
                curl->sub_table[3*prev + curr + 4];
            prev = curr;
        }
    }

    // Round 81: from scratchpad to state
    prev = curl->scratchpad[STATE_SIZE];
    for(int i = 0; i < STATE_SIZE; i++) {
        curr = curl->scratchpad[STATE_SIZE + curl->indices[i]];
        curl->state[i] = curl->sub_table[3*prev + curr + 4];
        prev = curr;
    }
}

#endif // CURL_C