#include "mbed.h"
#include "Camera_LS_Y201.h"
#include "SDFileSystem.h"

#define EnDebugMSG  true //true-> print debug message to PC USB terminal, false->not print
#include "filelib.h"

#define DEBMSG      pc.printf
#define NEWLINE()   pc.printf("\r\n")
 
#define USE_SDCARD 1
 
#if USE_SDCARD
#define FILENAME    "/wfs/IMG_%04d.jpg"
SDFileSystem sd(PB_3, PB_2, PB_1, PB_0, "wfs");
#else
#define FILENAME    "/local/IMG_%04d.jpg"
LocalFileSystem fs("local");
#endif
Camera_LS_Y201 cam1(PA_14, PA_13); //rx tx

Serial pc (USBTX,USBRX);    // tx, rx


DigitalOut lede (PC_8);


typedef struct work {
    FILE *fp;
} work_t;
 
work_t work;

int take_picture = 0;
 
/**
 * Callback function for readJpegFileContent.
 *
 * @param buf A pointer to a buffer.
 * @param siz A size of the buffer.
 */
void callback_func(int done, int total, uint8_t *buf, size_t siz) {
    fwrite(buf, siz, 1, work.fp);
 
    static int n = 0;
    int tmp = done * 100 / total;
    if (n != tmp) {
        n = tmp;
        DEBMSG("Writing...: %3d%%", n);
        NEWLINE();
    }
}
 
/**
 * Capture.
 *
 * @param cam A pointer to a camera object.
 * @param filename The file name.
 *
 * @return Return 0 if it succeed.
 */
int capture(Camera_LS_Y201 *cam, char *filename) {
    /*
     * Take a picture.
     */
    if (cam->takePicture() != 0) {
        return -1;
    }
    DEBMSG("Captured.");
    NEWLINE();
 
    /*
     * Open file.
     */
    work.fp = fopen(filename, "wb");
    if (work.fp == NULL) {
        return -2;
    }
 
    /*
     * Read the content.
     */
    DEBMSG("%s", filename);
    NEWLINE();
    if (cam->readJpegFileContent(callback_func) != 0) {
        fclose(work.fp);
        return -3;
    }
    fclose(work.fp);
 
 // Stop taking pictures.
     
    cam->stopTakingPictures();
 
    return 0;
}
 


int main()
{
    
pc.baud(38400); 
 
    DEBMSG("Camera module");
    NEWLINE();
    DEBMSG("Resetting...");
    NEWLINE();
    lede = true;
    if (cam1.reset() == 0) {
        DEBMSG("Reset OK.");
        NEWLINE();
    } else {
        DEBMSG("Reset fail.");
        NEWLINE();
        error("Reset fail.");
        lede = false;
    }

    if (cam1.setImageSize() == 0) {
        DEBMSG("Set image OK.");
        NEWLINE();
    } else {
        DEBMSG("Set image fail.");
        NEWLINE();
        error("Set image fail.");
        lede = false;
    }
    wait(1);

    int cnt = 0;
    while (cnt < 1) {
        lede = false;
        char fname[64];
        snprintf(fname, sizeof(fname) - 1, FILENAME, cnt);
        int r = capture(&cam1, fname);
        if (r == 0) {
            DEBMSG("[%04d]:OK.", cnt);
            NEWLINE();
        } else {
            DEBMSG("[%04d]:NG. (code=%d)", cnt, r);
            NEWLINE();
            error("Failure.");
        }
        cnt++;
    }
    lede = true;

}
