#include "mbed.h"
#include "SDFileSystem.h"
#include "WizFi310Interface.h"
#include "FTPClient.h"
#include <string.h>
#include <stdio.h>

#define FTP_SERVER_PORT     21
#define SECURE WizFi310::SEC_WPA2_MIXED
#define SSID "cdi1"
#define PASS "cdilab17"
 
FTPClient FTP(PB_3, PB_2, PB_1, PB_0, "sd"); // WIZwiki-W7500 
#if defined(TARGET_WIZwiki_W7500)
WizFi310Interface wizfi310(D1, D0, D7, D6, D8, NC, 115200);
Serial pc(USBTX, USBRX);
#endif

int main() {
    pc.baud(115200);
    
    pc.printf("------------------------------FTP Client Example-------------------------------------------!\r\n"); 
      
  
   // char ftpServer_control_ip_addr[] = "172.16.126.15"; // FTP Server location
    
    
    wizfi310.init();
    if ( wizfi310.connect(SECURE, SSID, PASS, WizFi310::WM_STATION))      return -1;
    printf("After Connect. \r\n");
    printf("IP Address of client is %s\r\n", wizfi310.getIPAddress());
    pc.printf("\nConnecting...FTPServer\r\n");
                    
    //bool n  = FTP.open("172.16.226.36", 21,"FTP","user");
    /*TO connect to online Server uncomment the below line*/
    bool n  = FTP.open("demo.wftpserver.com", 21,"demo-user","demo-user");
    
    printf("\nThe Files and folders available in the server are :\r\n");
    FTP.ls();
    printf("\r\n");
    wait(10);
    /*printf("\n the recieved file is:");
    FTP.getfile("/sd/mb.txt","m.txt");
    printf("\nFile recieved successful");*/
    
    printf("The Files in upload folder are :\r\n");
    FTP.cd("/upload");
    FTP.ls();
    //FTP.getfile("/sd/dict.db","dict.db");
    wait(10);
    //FTP.putfile("/sd/vlcsnap-3279000.jpg","mpd.jpg");
    
    printf("The Files in download folder are :\r\n");
    FTP.cd("/download");
    FTP.ls();
    printf("\r\n");
    wait(10);
    
     //To disconnect the FTP connection
    printf("\nCompleted .. you may exit now.\n");
    FTP.quit();
}