#ifndef FTP_CLIENT_H
#define FTP_CLIENT_H
#include "mbed.h"
#include "SDFileSystem.h"
#define MAX_SS              256
/** FTPClient class.
 *  Used file transfer with FTPServer like ALFTP(http://software.altools.co.kr/ko-kr/closed.html)
 *  This test was completed in ALFTP
 */
class FTPClient{
public:
    /** Create FTPClient instance */
    FTPClient(PinName mosi, PinName miso, PinName sclk, PinName ssel, const char* root);
    ~FTPClient() {};
    
    //bool open(char []); //new open command to check
    
    /** Connect to FTPServer
     *
     * @param FTPServer IP, FTPServer PORT, FTPServer login ID, FTPServer login PASS
     * @returns
     *   1 on success,
     *   0 on open error
     */
     bool open(char [], int, char [], char []);
    //bool open(char* ip, int port, char* id, char* pass);
    
    /** Get file from FTPServer
     *
     * @param My file name, FTPServer file name 
     * @returns
     *   1 on success,
     *   0 on getfile error
     */
    bool getfile(char* myfilename, char* filename);
    
    /** Put file to FTPServer
     *
     * @param My file name, FTPServer file name 
     * @returns
     *   1 on success,
     *   0 on putfile error
     */
    bool putfile(char* myfilename, char* filename);
    
    /** View FTPServer directory
     *
     * @param 
     * @returns
     *   1 on success,
     *   0 on dir error
     */
    bool dir();
    
    /** View FTPServer directory
     *
     * @param 
     * @returns
     *   1 on success,
     *   0 on ls error
     */
    bool ls();
    
    /** Delete FTPServer file
     *
     * @param FTPServer file name
     * @returns
     *   1 on success,
     *   0 on delete error
     */
    bool fdelete(char* filename);
    
    /** Make FTPServer directory
     *
     * @param FTPServer directory name
     * @returns
     *   1 on success,
     *   0 on mkdir error
     */
    bool mkdir(char* dirname);
    
    /** Change current FTPServer directory
     *
     * @param FTPServer directory name
     * @returns
     *   1 on success,
     *   0 on mkdir error
     */
    bool cd(char* dirname);
    
    /** Disconnect from FTPServer
     *
     * @param 
     * @returns
     *   1 on success,
     *   0 on Disconnect error
     */
    bool quit();
      
private:
    TCPSocketConnection* FTPClientControlSock;
    TCPSocketConnection* FTPClientDataSock;
    
    bool blogin;
    bool bopenflag;
    bool brfileflag;
    bool bsfileflag;
    bool bdirflag;
    bool blsflag;
    bool bfdeleteflag;
    bool bmkdirflag;
    bool bcdflag;
    bool bquitflag;
    
    char ftpServer_data_ip_addr[4];
    char ftpServer_data_ip_addr_str[20];
    int remote_port;
    
    char rbuf[256];
    char sbuf[256];

    int remain_datasize;
    int i;
    int remain_filesize;
    int send_byte;
    int size;
    FILE *fp;
    SDFileSystem _SDFileSystem;
    
    int pportc(char * arg);
};
#endif