#include "mbed.h"
#include "PwmIn.h"
#include "Nucleo_Encoder_16_bits.h"

#define Avance_rapide 100, 100
//#define Vitesse1 1, 50, 1, 50
//#define Vitesse2 1, 100, 1, 100

PwmOut      Pwm_MG  (PB_10);
PwmOut      Pwm_MD  (PB_3);
DigitalOut  En      (PC_9);
DigitalOut  SensG   (PC_8);
DigitalOut  SensD   (PC_6);

void motor_command(int mg_command, int md_command, float* mg_pwm, float* md_pwm, int* mg_sens, int* md_sens);

//Instructions

//mg_command et md_command compris entre -100 et 100
//void moteur_command(double sensD, double pwmD, double sensG, double pwmG);

void main (void)
{
    //Variables
    En = 1;
    float md_pwm = 0;
    float mg_pwm = 0;
    int md_sens = 1;
    int mg_sens = 1;
    
    while(1)
    {
        //Appel fonction

        motor_command(Avance_rapide, &mg_pwm, &md_pwm, &mg_sens, &md_sens);
        }
}

void motor_command(int mg_command, int md_command, float* mg_pwm, float* md_pwm, int* mg_sens, int* md_sens) {
    if(mg_command >= 0) {
        *mg_sens = 0;
        *mg_pwm = ((mg_command%101)/100);
    } else {
        *mg_sens = 1;
        *mg_pwm = ((-mg_command%101)/100);
    }
    if(md_command >= 0) {
        *mg_sens = 0;
        *md_pwm = ((md_command%101)/100);
    } else {
        *md_sens = 1;
        *md_pwm = ((-md_command%101)/100);
    }
}