#include "CommandExecution.h"
#include "flash_programming.h"
#include "ReadSensor.h"
#include "mbed.h"

DigitalOut  relay1(RELAY_1_PIN);
DigitalOut  relay2(RELAY_2_PIN);
DigitalOut  relay3(RELAY_3_PIN);

extern bool   isCalibrating;
extern bool   isUploadImmediately;
extern float  doValue;

void CE_HandleRelays(int Relay1State, int Relay2State, int Relay3State) {
    relay1 = Relay1State;
    relay2 = Relay2State;  
    relay3 = Relay3State;
}

void CE_SetRTCTime(uint32_t CurrentEpochTime) {
    printf("New local time value set\r\n");
    set_time(CurrentEpochTime);
}

void CE_Calibrate() {
    isCalibrating = true;
}

void CE_SetAlarmRelays() {
    
}

void CE_UpdateImmediately() {
    isUploadImmediately = true;
}

