#ifndef __LM35_H__
#define __LM35_H__

#include "mbed.h"

#define SAMPLE_COUNT    30

class LM35Therm {
private:
    AnalogIn *_pAin;
    bool  _isFirstRead;
    
    float _sumAnalog;
    float _calibrate;
    
    float analogSamples[SAMPLE_COUNT];
    float analogAverageSamples[SAMPLE_COUNT];    
//    float _readVoltage;
    
public:
    float tempInC;
    float tempInF;
    
    float averageAnalog;
    float filtedAvgAnalog;
    
    float _readVoltage;
    
public:
    LM35Therm(PinName analogPin, float compensation);
    
    ~LM35Therm();
    
    void  getAverageValue();
    void  setCompensation(float newCompensation);
    float getTempInC();
    float getTempInF();    
        
};

#endif /* __LM35_H__ */