#include "LM35.h"

LM35Therm::LM35Therm(PinName analogPin, float compensation) {
    _pAin = new AnalogIn(analogPin);
    _calibrate = compensation;
    _isFirstRead = true;
}

LM35Therm::~LM35Therm() {
    delete _pAin;
}

void LM35Therm::getAverageValue() {
    _sumAnalog = 0;
    
    for (uint8_t i = 0; i < SAMPLE_COUNT; i++) {
        analogSamples[i] = _pAin->read();
    }  
    
    for (uint8_t i = 0; i < SAMPLE_COUNT; i++) {
        _sumAnalog = _sumAnalog + analogSamples[i];   
    }  
    
    averageAnalog = _sumAnalog / SAMPLE_COUNT;
    _sumAnalog = 0;
    
    if (_isFirstRead) {
        for (uint8_t i = 0; i < SAMPLE_COUNT; i++) {
            analogAverageSamples[i] = averageAnalog;
            _sumAnalog = _sumAnalog + analogAverageSamples[i];
        }        
        filtedAvgAnalog = _sumAnalog / SAMPLE_COUNT;
        _isFirstRead = false;    
    }
    else {
        for (uint8_t i = 0; i < SAMPLE_COUNT - 1; i++) {
            analogAverageSamples[i] = analogAverageSamples[i];
            _sumAnalog = _sumAnalog + analogAverageSamples[i];
        }       
        analogAverageSamples[SAMPLE_COUNT - 1] = averageAnalog;      
        _sumAnalog = _sumAnalog + analogAverageSamples[SAMPLE_COUNT - 1];
    }
    filtedAvgAnalog = _sumAnalog / SAMPLE_COUNT;
}

void LM35Therm::setCompensation(float newCompensation) {
    _calibrate = newCompensation;
}

float LM35Therm::LM35Therm::getTempInC() {
    _readVoltage  = filtedAvgAnalog * 3.3;
    float avgVolt = filtedAvgAnalog * _calibrate * 1000.0;
    tempInC       = avgVolt;
    return tempInC;
}

float LM35Therm::LM35Therm::getTempInF() {
    tempInF = (9.0 * tempInC)/5.0 + 32.0;
    return tempInF;
}