// Author:  Jack Justice
// Created: 10-1-2019

#include "mbed.h"

#define LED_PIN D7

int main()
{
    // Documentation on Serial API >> https://os.mbed.com/docs/mbed-os/v5.14/mbed-os-api-doxy/classmbed_1_1_serial.html
    
    // If I wished to set some baud, I could add the baud in as a third param
    //   in the Serial object initialization.
    Serial UART(USBTX, USBRX);     // UART(TX_pin, RX_pin, baud);
    UART.printf("Hello World!\n");
    
    // Documentation on DigitalOut API >> https://os.mbed.com/docs/mbed-os/v5.14/mbed-os-api-doxy/classmbed_1_1_digital_out.html
    
    // Let's start toggling our LED by initializing D7 to be off.
    DigitalOut led(LED_PIN, 0);
    
    while(true)
    {
        // The 'F' on the end of 0.5 is there to force the compiler to treat 0.5 as a float.
        //   It may treat it like an integer, making the wait function not pause.
        wait(0.5F);
        
        // Documentation on Wait function >> https://os.mbed.com/docs/mbed-os/v5.14/apis/wait.html
        
        // Because the LED's initial state is off, we must turn it on.
        // ON == 1, OFF == 0
        led.write(1);
        
        // Wait for half a second
        wait(0.5F);
        
        // And turn the LED off
        led.write(0);
    }
}