#include "mbed.h"
#include "MODSERIAL.h"
#include "BiQuad.h"
#include "BiQuad4.h"
#include "FilterDesign.h"
#include "FilterDesign2.h"
#include "HIDScope.h"
MODSERIAL pc(USBTX, USBRX); //makes sure the computer is hooked up
Ticker sample;

AnalogIn emg1_raw(A0);
AnalogIn emg2_raw(A1);
DigitalOut led(LED_RED);

//global variables
double emg1_cal = 0.00000; //measured value of the first emg
double emg2_cal = 0.00000; //measured value of the second emg
double EMG_calibrated_max_1 = 0.00000; //final calibration value of EMG1
double EMG_calibrated_max_2 = 0.00000; //final calibration value of EMG2

void ReadEMG()
{
    emg1_cal = FilterDesign(emg1_raw.read());
    emg2_cal = FilterDesign2(emg2_raw.read());
}

void EMG_calibration()
{
    for (int i = 0; i <= 10; i++) //10 measuring points
        {      
        if (emg1_cal > EMG_calibrated_max_1){
            EMG_calibrated_max_1 = emg1_cal;}
            
        if (emg2_cal > EMG_calibrated_max_2){
            EMG_calibrated_max_2 = emg2_cal;}
            
        pc.printf("EMG1 = %f, EMG2 = %f \r\n",EMG_calibrated_max_1,EMG_calibrated_max_2);
        wait(0.5f);
        }
}

        

int main(){
    pc.baud(115200);
    // Attach the 'ReadEMG' function to the timer 'sample'. Frequency is 5 Hz.
    sample.attach(&ReadEMG, 0.2f);
    
    while (true) {
        led = 0;
        EMG_calibration();
        led = 1;
        pc.printf("Final: EMG1 = %f, EMG2 = %f \r\n",EMG_calibrated_max_1,EMG_calibrated_max_2);
    }
}