#include "FilterDesign.h"
#include "BiQuad.h"
#include "BiQuad4.h"

// Notch filter op 50 Hz
double nb0 = 0.999103206817809;
double nb1 = -1.994263409725146;
double nb2 = 0.999103206817809;
double na1 = -1.994263409725146;
double na2 = 0.998206413635618;

// 4th order Butterworth High pass 10 Hz
double hpb0 = 0.922946103200875;
double hpb1 = -3.691784412803501;
double hpb2 = 5.537676619205252; 
double hpb3 = -3.691784412803501;
double hpb4 = 0.922946103200875;
double hpa1 = -3.839672788481732;
double hpa2 = 5.531745865737864;
double hpa3 = -3.543889487580057;
double hpa4 = 0.851829509414351;

/*
// 4th order Butterworth Low pass 6 Hz
double lpb0 = 0.000000109473538449645 ;
double lpb1 = 0.000000437894153798579 ;
double lpb2 = 0.000000656841230697869; 
double lpb3 = 0.000000437894153798579;
double lpb4 = 0.000000109473538449645;
double lpa1 = -3.903798995738811;
double lpa2 = 5.715997307717368;
double lpa3 = -3.720469814151233;
double lpa4 = 0.908273253749291;
*/

//4th order Butterworth low pass 9 Hz
double lpb0 = 0.00000054134117189603 ;
double lpb1 = 0.00000216536468758410  ;
double lpb2 = 0.00000324804703137616; 
double lpb3 = 0.00000216536468758410;
double lpb4 = 0.00000054134117189603;
double lpa1 = -3.855703428197204;
double lpa2 = 5.577429961461492;
double lpa3 = -3.587322565783154;
double lpa4 = 0.865604693977616;

double gain = 10.00000;

BiQuad notch50(nb0, nb1, nb2, na1, na2);
BiQuad4 highpass(hpb0, hpb1, hpb2, hpb3, hpb4, hpa1, hpa2, hpa3, hpa4);
BiQuad4 lowpass(lpb0, lpb1, lpb2, lpb3, lpb4, lpa1, lpa2, lpa3, lpa4);

double FilterDesign(double u)
{   
    double y_n = notch50.step(u);
    double y_hp = highpass.step(y_n);
    double y_abs = abs(y_hp);
    double y_lp = lowpass.step(y_abs);
    double y_gain = y_lp*gain;
    
    return y_gain;
}