//Determining the setpoint that the thing will have to follow
#include "mbed.h"
#include "MODSERIAL.h"
Ticker SetX;
DigitalIn button(SW2);
DigitalIn direction(SW3);
MODSERIAL pc(USBTX, USBRX); //makes sure the computer is hooked up

//defining of the variables
//static float x_prev = 0; //previous setpoint
float x_new = 0; //new setpoint
const float x_max = 20; //maximum value of setpoint
const float x_min = 0; //minimum value of setpoint
float v=1; //moving speed of setpoint (dependant on the waiting time)
volatile int s;//value of the button and store as switch
int dir = 1; //determine the direction of the setpoint placement

//equation is x_new = x_prev + dir*s*v*dt

//function that determines the setpoint of the x coordinate
float EMG1On(int s){
    if (x_new < x_min) //minimum setpoint (set above)
        x_new = x_min;
    if (x_new > x_max) //maximum setpoint (set above)
        x_new = x_max;
    else x_new = x_new + dir*s*v;
    return x_new;
    }

//function to change the moving direction of the setpoint
void ChangeDirection(){
    dir = -1*dir;
    }

int main()
{
    InterruptIn direction(SW3);
    direction.fall(ChangeDirection); //change the direction of the setpoint
    
    pc.baud(115200);
    
    while (true) {  
    s = !button.read(); //this has to be replaced with the input from the EMG, this then functions like a button
    pc.printf("Value: %i, Set: %f \r\n",s,EMG1On(s)); //print the value of the button to check if it is correct
    wait(0.5f); //together with the speed (v) 
    }
}
