#include "mbed.h"
#include "MODSERIAL.h"
#include "math.h"

Ticker SetX;
DigitalIn directionx(PTC2); //x direction switch button
DigitalIn directiony(PTA2); //y direction switch button
DigitalIn buttonx(SW2); //x EMG replacement 
DigitalIn buttony(SW3); //y EMG replacement
MODSERIAL pc(USBTX, USBRX); //makes sure the computer is hooked up

//defining of the variables
//static float x_prev = 0; //previous setpoint
const double r_big = 590.0; //maximum radius of the moving space
const double r_small = 162.0; //minimum radius of the moving space
const double r_top = 250.0; //radius of the top portion of the moving space
double v=1.0; //moving speed of setpoint (dependant on the waiting time)
volatile int sx;//value of the button and store as switch
volatile int sy;//value of the button and store as switch
int dirx = 1; //determine the direction of the setpoint placement
int diry = 1; //determine the direction of the setpoint placement

double q1_diff;
double q2_diff;
const double pi = 3.14159265358979323846; //definition of pi
double sq = 2.0; //to square numbers
const double x0 = 80.0; //zero x position after homing
const double y0 = 141.0; //zero y position after homing
const double L1 = 250.0; //length of the first link
const double L3 = 350.0; //length of the second link

volatile double x = x0; //sets the begin condition for x to x0
volatile double y = y0; //sets the begin condition for y to y0

//equation to determine the setpoint is x = x + dirx*s*v*dt

//function that determines the setpoint of the x coordinate
double EMG1On(int s){
    if (x < 80.0) //minimum setpoint
        x = x;
    if (y > -66.0){ //defines the large circle endpoint
        if (y < 362.0){
            if (sqrt(pow(x,sq)+pow(y,sq)) > r_big){
        x = x;}}}
    if (y > 141.0){ //defines the top circle endpoint
        if (x < 540.0){
            if (sqrt(pow(y-119.2,sq)+pow(x-329.0,sq)) > r_top){
                x = x;}}}
    if (x > 80.0){ //defines the small circle endpoint
        if (y > -36.0){
            if (sqrt(pow(x,sq)+pow(y,sq)) < r_small){
                x = x;}}}
    if (y > -66.0){ //kleine stukje
        if (y < -36.0){
            if (x < 157.0){
                x = x+2;}}}
    else x = x + dirx*s*v;
    return x;
    }
    
//function that determines the setpoint of the x coordinate
double EMG2On(int s){
    if (y < -66.0) //bottom line
        y = y;
    if (y > -66.0){ //defines the large circle endpoint
        if (y < 362.0){
            if (sqrt(pow(x,sq)+pow(y,sq)) > r_big){
                y = y;}}}
    if (y > 141.0){ //defines the top circle endpoint
        if (x < 540.0){
            if (sqrt(pow(y-119.2,sq)+pow(x-329.0,sq)) > r_top){
                y = y;}}}
    if (x > 80.0){ //defines the small circle endpoint
        if (y > -36.0){
            if (sqrt(pow(x,sq)+pow(y,sq)) < r_small){
                y = y;}}}
    else y = y + diry*s*v;
    return y;
    }

//function to change the moving direction of the setpoint
void ChangeDirectionX(){
    dirx = -1*dirx;
    }
    
void ChangeDirectionY(){
    diry = -1*diry;
    }


//reference angles of the starting position
double q2_0 = pi + acos((pow(x0,sq)+pow(y0,sq)-pow(L1,sq)-pow(L3,sq))/(2.0*L1*L3));
double q1_0 = atan(y0/x0)+acos((-pow(L3,sq)+pow(L1,sq)+pow(x0,sq)+pow(y0,sq))/(2.0*L1*sqrt(pow(x0,sq)+pow(y0,sq))));
double q2_0_enc = q2_0 + q1_0;

//function to calculate the angle from 
double makeAngleq1(double x, double y){

//double q2 = -acos((pow(x,sq)+pow(y,sq)-pow(L1,sq)-pow(L3,sq))/(2.0*L1*L3)); //angle of the second joint in setpoint configuration

double q1 = atan(y/x)+acos((-pow(L3,sq)+pow(L1,sq)+pow(x,sq)+pow(y,sq))/(2.0*L1*sqrt(pow(x,sq)+pow(y,sq)))); //angle of the first joint in the setpoint configuration

//double q2_motor = pi - q2; //because q2 represents the angle at joint two and not at the motor a calculation has to be done

q1_diff = -2.0*(q1-q1_0); //the actual amount of radians that the motor has to turn in total to reach the setpoint
//q2_diff = 2.0*(q2_motor - q2_0); //the actual amount of radians that the motor has to turn in total to reach the setpoint

//double q_diff[2] = {q1_diff,q2_diff}; //make a vector so the answer can be returned
//q_diff[0] = q1_diff and q_diff[1] = q2_diff


return q1_diff;
}


//function to calculate the angle from 
double makeAngleq2(double x, double y){

double q2 = -acos((pow(x,sq)+pow(y,sq)-pow(L1,sq)-pow(L3,sq))/(2.0*L1*L3)); //angle of the second joint in setpoint configuration

double q1 = atan(y/x)+acos((-pow(L3,sq)+pow(L1,sq)+pow(x,sq)+pow(y,sq))/(2.0*L1*sqrt(pow(x,sq)+pow(y,sq)))); //angle of the first joint in the setpoint configuration

double q2_motor = (pi - q2)+q1; //because q2 represents the angle at joint two and not at the motor a calculation has to be done

//q1_diff = 2.0*(q1-q1_0); //the actual amount of radians that the motor has to turn in total to reach the setpoint
q2_diff = -2.0*(q2_motor - q2_0_enc); //the actual amount of radians that the motor has to turn in total to reach the setpoint

//double q_diff[2] = {q1_diff,q2_diff}; //make a vector so the answer can be returned
//q_diff[0] = q1_diff and q_diff[1] = q2_diff


return q2_diff;
}


int main()
{
    InterruptIn directionx(PTC2);
    directionx.fall(ChangeDirectionX); //change the direction of the setpoint in x direction
    InterruptIn directiony(PTA3);
    directiony.fall(ChangeDirectionY); //change the direction of the setpoint in y direction
    
    pc.baud(115200);
    
    while (true) {
        sx = !buttonx.read(); //this has to be replaced with the input from the EMG, this then functions like a button
        sy = !buttony.read(); //this has to be replaced with the input from the EMG, this then functions like a button
        x = EMG1On(sx);
        y = EMG2On(sy);
        q1_diff = makeAngleq1(x,y);
        q2_diff = makeAngleq2(x,y);
        pc.printf("sx: %i, sy: %i, x: %f, y: %f, q1_diff: %f, q2_diff: %f\r\n",sx,sy,x,y,q1_diff,q2_diff);
        wait(2.0f);
        //makeAngle(EMG1On(),EMG2On());
    }
}