#include "UsbBaseClass.h"
//#define __DEBUG
#include "mydbg.h"

UsbBaseClass::UsbBaseClass()
{
    if (m_pHost == NULL) {
        m_pHost = new UsbHostMgr;
        DBG_ASSERT(m_pHost);
        m_pHost->init();
    }
    DBG("m_pHost=%p\n", m_pHost);
}

UsbErr UsbBaseClass::Usb_poll(int timeout, int timeout2)
{
    DBG("%p %d %d\n", this, timeout, timeout2);
    Timer t;
    t.reset();
    t.start();
    Timer t2;
    t2.reset();
    t2.start();
    while(t.read_ms() < timeout) {
        UsbErr rc = m_pHost->poll();
        if (rc == USBERR_PROCESSING) {
            t2.reset();
        }
        if (t2.read_ms() > timeout2) {
            DBG("%p t=%d\n", this, t.read_ms());
            return USBERR_OK;
        }
        wait_ms(50);
    }
    return USBERR_PROCESSING;
}

UsbHostMgr* UsbBaseClass::m_pHost = NULL;
