#if 1
#include "mbed.h"
#include "uvc.h"
//#include "msc.h"
#include "SDHCFileSystem.h"
#include<vector>
Serial pc(USBTX, USBRX);//Serial class 
DigitalOut led1(LED1), led2(LED2), led3(LED3), led4(LED4);

//SDFileSystem class 
SDFileSystem sd(p5, p6, p7, p8, "sd");
//#define FILENAME "/sd/cam%04d.jpg"

//LocalFileSystem class
LocalFileSystem local("local");
#define FILENAME "/local/cam%04d.jpg"

#define INTERVAL_MS 10000
#define CAM_N 1
#define SHOT_N 1

vector <uvc*> vec_cam;
Timer t;
int main()
{
    pc.baud(9600);
    wait_ms(1000);
    printf("%s\n", __FILE__); //sourcefilename printout
    printf("start!!\n");
    //msc* usb = new msc("usb"); //usb storage class
    //if (usb->setup() < 0) exit(1);
    
    FILE *fp;
    if ((fp=fopen(FILENAME,"wb")) == NULL) return -1; //"wb" : write and binary mode
    
    for(int n = 0; n < CAM_N; n++) {
        uvc* cam = new uvc(n);
        cam->SetImageSize(320, 240);
        cam->SetFrameInterval(2000000);
        if (cam->setup() < 0) {
            break;
        }
        vec_cam.push_back(cam);
    }
    t.start();
    for (int n = 0; n < SHOT_N; n++) {
        int cam = n % vec_cam.size();
        t.reset();
        char path[32];
        //snprintf(path, sizeof(path), "/usb/cam%1d%03d.jpg", cam, n%100);
        snprintf(path, sizeof(path), FILENAME, n);
        int len = vec_cam[cam]->get_jpeg(path);
        printf("%d %s %d\n", n, path, len);
        while(t.read_ms() < INTERVAL_MS) {
            for(int n = 0; n < vec_cam.size(); n++) {
                vec_cam[n]->poll();
            }
        }
    }
    printf("finish!!\n");
    fclose(fp);
    exit(1);
}
#endif