#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "TextLCD.h" //LCD用

TextLCD lcd(p24, p26, p27, p28, p29, p30); //LCDの設定

LocalFileSystem fs("webfs"); //ファイルシステムの設定
  

EthernetNetIf eth;  
HTTPServer svr;

DigitalOut led1(LED1);

int main() {
  lcd.cls();
  lcd.printf("Setting up...\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    lcd.cls();
    lcd.printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  lcd.cls();
  lcd.printf("Setup OK\n");
  
  FSHandler::mount("/webfs", "/"); //ここで /webfs をWebパスのルートに割り当てる
 
  svr.addHandler<SimpleHandler>("/"); //Default handler
  svr.bind(80);
  
  lcd.cls();
  lcd.printf("Listening...\n");
    
  Timer tm;
  tm.start();
  //Listen indefinitely
  while(true)
  {
    Net::poll();
    if(tm.read()>.5)
    {
      led1=!led1; //Show that we are alive
      tm.start();
    }
  }
  
  return 0;
}
