/*
*           Creator: Matthias Hemmer
*           created: 15.04.2016
*       
*   function: write a register of 8 bits to the WS2811 RGBs 
*/
#include "mbed.h"
#include "WS2811.h"

uint8_t ledmatrix[LED_MAX][3];

DigitalOut myled(P0_22);

void writeled(int pos, uint8_t g, uint8_t r, uint8_t b){    // define the register
    ledmatrix[pos][0] = g;      // green register
    ledmatrix[pos][1] = r;      // red register
    ledmatrix[pos][2] = b;      // blue register
}

void writeledbit(char wert){
    
    if(wert){           // example: if(1) than make what is declatrated
        myled = 1;
            for(int i=0;i<HIGH_SIGNAL;i++) __nop();     // wait is to slow, becouse reset = 50µs
        myled = 0;
            for(int i=0;i<LOW_SIGNAL;i++) __nop();
    }
    
    else{   // else make this
        myled = 1;
            for(int i=0;i<LOW_SIGNAL;i++) __nop();
        myled = 0;
            for(int i=0;i<HIGH_SIGNAL;i++) __nop();
    }
}

void sendColours(int pos, uint8_t r, uint8_t g, uint8_t b){
    //__disable_irq;          // disable interrupt to speed up
            writeled(pos, g, r, b);     // call the underprogramm
    
    for(int led = 0; led < LED_MAX; led++){     // write the matrix on the RGBs
        for(int i = 0; i < 3; i++){         // write the position
            for(int b = 0; b < 8; b++){     // write the bit
                writeledbit(ledmatrix[led][i] & 1<<b);  // write the byte on the RGBs
            }
        }
    }
    wait(DELAY);        // wait for the supply voltage
   // __enable_irq;          // enable interrupt pin for the basic uses
}