/*
*       Lib for the Bertl 2014 Bulme
*       Creator: Matthias Hemmer
*
*/  
#define Addrs   0x40    // A2 = A1 = A0 = 0
#define FREQUENCY   100000  // f in Hz

// Configurate Ports at the PCA9555
#define Input0  (0)
#define Input1  (1)
#define Output0 (2)
#define Output1 (3)
#define Invers0 (4) // must be configurated
#define Invers1 (5) // must be configurated 
#define Config0 (6) // must be configurated
#define Config1 (7) // must be configurated

// Confiurate LEDs
#define d1 0x01
#define d2 0x02
#define d4 0x04
#define d5 0x08
#define d6 0x10
#define d7 0x20
#define d8 0x40     // not working
#define d9 0x80

#define WHITE (d1|d4)
#define ORANGE (d2|d5|d7|d9)
#define RED (d6|d8)

// Configurate buttons
#define TA1 1
#define TA2 2
#define TA3 4
#define TA4 8
#define TA5 16
#define TA6 32
#define TA7 64
#define TA8 128

#define front (TA3|TA1|TA4|TA7|TA8)
#define back (TA5|TA2|TA6)

void init();
void leds(unsigned char leds);
unsigned char buttons();