#include "I2C.h"
#include "mbed.h"

I2C i2c(p28, p27);   // (SDA, SCL)

void init(){
        char data[2];
        
        i2c.frequency(FREQUENCY);
        
        // port 0 = LEDs
        
        // declaration of polarity inversion port 0
        data[0] = Invers0;
        data[1] = 0xFF;     // Input
        i2c.write(Addrs, data, 2);
        
        // declaration of polarity inversion port 1
        data[0] = Invers1;
        data[1] = 0x00;     // Output
        i2c.write(Addrs, data, 2);
        
        // declaration of the Configuration port 0
        data[0] = Config0;
        data[1] = 0x00;     // Input
        i2c.write(Addrs, data, 2);
        
        // declaration of the Configuration port 1
        data[0] = Config1;
        data[1] = 0xFF;     // Output
        i2c.write(Addrs, data, 2);
    }
    
void leds(unsigned char leds){
        char data[2];
        
        data[0] = Output0;
        data[1] = ~leds;        // look PCA9555 datasheet
        i2c.write(Addrs, data, 2);
    }
    
unsigned char buttons(){
        char data[1];
        
        data[0] = Input1;
        i2c.write(Addrs, data, 1, false);       // don't stop, becouse we want to read from Input1 the buttons
        i2c.read(Addrs, data, 1, true);
        
        return ((unsigned char) data[0]);
        
    }