/**by Austin Saunders

*/

#include <mbed.h>
#include "MCP3008.h"

MCP3008::MCP3008(PinName mosi, PinName miso, PinName clk, PinName cs)
:   _spi(mosi,miso,clk),
    _cs(cs),
    _vref(3.3)
{
    _spi.frequency(1000000);
    _spi.format(8,0);
    _cs = 1;
}
 
int
MCP3008::read(int ch)
{
    _cs = 0;
    _spi.write(0x01);                   
    _data1 = _spi.write(0x80|(ch<<4));
    _data2 = _spi.write(0x00);
    int adb = (_data1<<8) | _data2; 
    adb = (adb & 0x03FF);
    _cs = 1;
    float ain = (adb*_vref)/1023;
    return adb;
}