#include "PID.h"
#include "mbed.h"
 
#define RATE 0.0001

float setpoint,kp,ki,kd,pv_new;
PID controller(kp, ki, kd, RATE);
AnalogIn pv(p15);
PwmOut   co(p21);
Serial pc(USBTX, USBRX);

      
 
int main(){
pc.baud(19200);

//Set PWM period to 10us
co.period(100e-6);

 
  //Analog input from 0.0 to 1V
  controller.setInputLimits(0.0,1);
  //Pwm output from 0.0 to 1.0
  controller.setOutputLimits(0.0,1);
  //Add some bias to counter nonlinear effects
  controller.setBias(0.0);
  //Set mode to auto
  controller.setMode(AUTO_MODE);
  //controller.setMode(MANUAL_MODE);
  
  
  while(1){
    
    //Scan the labview environment for the setpoint and tuning parameters
    pc.scanf("%f,%f,%f,%f",&setpoint,&kp,&ki,&kd);
    
    //set the controller setpoint
    controller.setSetPoint(setpoint);
    
    //set the controller PID values
    controller.setTunings(kp, ki, kd);
    
    pv_new = pv.read();
    
    controller.setProcessValue(pv_new);
        
    //Set the new PWM output.
    co = controller.compute();
    
    //Send the PWM and PV values to Labview
    pc.printf("%f,%f,%f",co.read(),pv_new,setpoint);
    
    
    //Wait for another loop calculation.
    wait(RATE);
  }
 

}
