/* mbed AX-12+ Servo Library
 *
 * Copyright (c) 2010, cstyles (http://mbed.org)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTARE.
 */
#ifndef MBED_AX12_H
#define MBED_AX12_H

#include "mbed.h"
#include "BlockingSerial.h"

#define AX12_WRITE_DEBUG 0
#define AX12_READ_DEBUG 0
#define AX12_TRIGGER_DEBUG 0
#define AX12_DEBUG 0

#define AX12_REG_ID 0x3
#define AX12_REG_CW_LIMIT 0x06
#define AX12_REG_CCW_LIMIT 0x08
#define AX12_REG_GOAL_POSITION 0x1E
#define AX12_REG_MOVING_SPEED 0x20
#define AX12_REG_VOLTS 0x2A
#define AX12_REG_TEMP 0x2B
#define AX12_REG_MOVING 0x2E
#define AX12_REG_POSITION 0x24

#define AX12_MODE_POSITION  0
#define AX12_MODE_ROTATION  1

#define AX12_CW 1
#define AX12_CCW 0

class AX12 {

public:

    // define which pins are used, and the ID of this instance
    // Mutiple AX12's can share the same pins.
    AX12(PinName tx, PinName rx, int ID);

    // methods for writing and reading registers
    int read(int ID, int start, int length, char* data);
    int write(int ID, int start, int length, char* data, int flag=0);

    // set goal angle in integer degrees
    // flags[0] = blocking (only returns when goal reached
    // flags[1] = register. Requires broadcast trigger to activate
    int SetGoal(int degrees, int flags = 0);

    // Mode = 0, positional
    // Mode = 1, continuous rotation
    int SetMode(int mode);

    // Speed is -1.0 (CCW) to 1.0 (CW)
    int SetCRSpeed(float speed);

    // set these in degrees, CCW limit is 300
    // If both are set to zero, we are continuous rotation
    int SetCWLimit(int degrees);
    int SetCCWLimit(int degrees);

    // Change the ID
    int SetID(int CurrentID, int NewID);

    // returns true if the motor is in motion
    int isMoving(void);

    // broadcast to trigger registered goals
    void trigger(void);

    // Get current angle, only valid 0-300
    float GetPosition();

    // In volts and ^C
    float GetTemp(void);
    float GetVolts(void);

private :
    //SerialHalfDuplex _ax12;
    BlockingSerial _ax12;
    int _ID;

};

#endif
