#include "mbed.h"

DigitalOut myled(LED1);

#include "Keypad.h"
#include "CAN.h"

CAN can1(p30,p29);


  // Define your own keypad values
  char Keytable[] = { '1', '2', '3',    // r0
                      '4', '5', '6',    // r1
                      '7', '8', '9',    // r2
                      '*', '0', '#',    // r3
                    };
                   // c0   c1   c2   
 
  uint32_t Index;
 
  uint32_t cbAfterInput(uint32_t index) {
      Index = index;
      return 0;
  }
  
 void send(char *str) {
   printf("send(%s)\n",str);
    if(can1.write(CANMessage(1, str, 1))) {
        printf("wloop()\n");
        printf("Message sent: \n");
    } 
}
 
 
  int main() {
                  // r0   r1   r2   r3   c0   c1   c2   c3
      Keypad keypad(p21, p22, p23, p24, p25, p26, p27);
      keypad.attach(&cbAfterInput);
      keypad.start();  // energize the keypad via c0-c3
 
      while (1) {
          __wfi();
          printf("Interrupted\r\n");
        wait(0.5);
        char *msg = 0;
        *msg = Keytable[Index];
        send(msg);
          printf("Index:%d => Key:%c\r\n", Index, Keytable[Index]);
      }
  }