#include "config.h"
#include "ATcommand.h"

int configFromFile(char* path, Serial *xbee, Serial *pc, char * url){
    pc->printf("\n\rConfig Filename: %s", path); 
    
    int maxRetry = 2;
    
    FILE* file = fopen(path, "r");
    char line[256];
    while (fgets(line, sizeof(line), file)) {
        bool delimiterFound = false;
        
        // Line is a comment
        if( (line[0]=='#') || (line[0]=='\n')){
            pc->printf("\n\r%s", line); 
            
        // Line is url config
        }else if(strstr(line, "url") != NULL){
            int ptr = 0;
            for(int i =0;i<sizeof(line)&& line[i]!='\0'; i++){
                if(!delimiterFound){
                    delimiterFound = (line[i]=='=');
                }else{
                    url[ptr] = line[i];
                    ptr++;
                }
            }
            pc->printf("Url:%s", url); 
        
        // Others line is AT COMMAND
        }else{
            int ptr = 0;
            bool EOL = false;
            pc->printf("AT Command\n\r"); 
            for(int i =0;i<sizeof(line)&& !EOL; i++){
                if(!delimiterFound){
                    delimiterFound = (line[i]=='=');
                    pc->printf("%c",line[i]); 
                }else{
                    
                    // Send command
                    char *cmd = NULL;
                    char *params = NULL;
                    int cmd_len = 0;
                    int param_len = 0;
                    
                    for( ;i<sizeof(line)&& line[i]!= '\0'; i=i+2){
                        unsigned char c = ahex2bin(line[i],line[i+1]);
                        if(c == 0xDA){
                            EOL =true;
                        }else if(cmd_len <2){
                            cmd = (char*)realloc(cmd ,sizeof(char)*(cmd_len+1));
                            cmd[cmd_len++] = c;
                        }else{
                            params = (char*)realloc(params ,sizeof(char)*(param_len+1));
                            params[param_len++] =  c;
                        }
                    }
                    
                    do{
                        bool exit = false;
                        sendAT(xbee, pc, cmd, params,param_len);
                        wait_ms(200);
                        ATWR (xbee, pc);
                        wait_ms(200);
                        apply(xbee, pc);
                        wait_ms(200);                   
                        // Verify command status
                        char status = getStatusResponse(xbee, pc);
                        if(status == 0x00){
                            pc->printf("\n\rStatus OK"); 
                            exit =true;      
                        }else{
                            if(status==0x02){
                              pc->printf("\n\Invalid Command %d\n\r",status);  
                            }     
                            toggleError(xbee, pc, 200, "Warning status fail");  
                            maxRetry--;    
                        }
                    }while(maxRetry>0 && !exit);
                    free(cmd);
                    free(params);
                
                    EOL =true;
                }
            }
        }
    }
    fclose(file);
    pc->printf("\n\rClose file"); 
    return 0;
}


unsigned char ahex2bin (unsigned char MSB, unsigned char LSB){  
    if (MSB > '9') MSB -= 7;   // Convert MSB (0x30..0x3F)  
    if (LSB > '9') LSB -= 7;   // Convert LSB (0x30..0x3F)  
    return (MSB << 4) | (LSB & 0x0F); 
}
 
